/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ImageUrl {
    private static final Map<TemplateImageUrl, TemplateImageUrl> cache = new WeakHashMap<TemplateImageUrl, TemplateImageUrl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageUrl cache(TemplateImageUrl object) {
        Map<TemplateImageUrl, TemplateImageUrl> map = cache;
        synchronized (map) {
            ImageUrl cached = cache.get(object);
            if (cached != null) {
                return cached;
            }
            cache.put(object, object);
            return object;
        }
    }

    public static int cacheSize() {
        return cache.size();
    }

    public static final void main(String[] args) {
        ImageUrl url2;
        ImageUrl url = ImageUrl.builder("382581").addUrl(1, "https://cdn.frankerfacez.com/emote/382581/1").addUrl(2, "https://cdn.frankerfacez.com/emote/382581/2").build();
        System.out.println(url == (url2 = ImageUrl.builder("382582").addUrl(1, "https://cdn.frankerfacez.com/emote/382582/1").addUrl(2, "https://cdn.frankerfacez.com/emote/382582/2").build()));
        System.out.println(ImageUrl.builder("382581").addUrl(1, "https://cdn.frankerfacez.com/emote/382581/2").addUrl(2, "https://cdn.frankerfacez.com/emote/382581/2").build().getClass());
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    private static String buildUrl(String template, String id, int size) {
        return template.replace("{id}", id).replace("{x}", String.valueOf(size));
    }

    public abstract String getUrl(String var1, int var2);

    public static class TemplateImageUrl
    extends ImageUrl {
        private final String template;
        private final Set<Integer> sizes;

        private TemplateImageUrl(String template, Set<Integer> sizes) {
            this.template = template;
            this.sizes = sizes;
        }

        @Override
        public String getUrl(String id, int size) {
            if (this.sizes.contains(size)) {
                return ImageUrl.buildUrl(this.template, id, size);
            }
            return null;
        }

        public String toString() {
            return String.format("%s [%s]", this.template, this.sizes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateImageUrl other = (TemplateImageUrl)obj;
            if (!Objects.equals(this.template, other.template)) {
                return false;
            }
            return Objects.equals(this.sizes, other.sizes);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.template);
            hash = 53 * hash + Objects.hashCode(this.sizes);
            return hash;
        }
    }

    public static class Builder {
        private final Map<Integer, String> urls;
        private final String id;

        public Builder(String id) {
            this.id = id;
            this.urls = new HashMap<Integer, String>();
        }

        public Builder(String id, Map<Integer, String> urls) {
            this.id = id;
            this.urls = urls;
        }

        public Builder addUrl(int size, String url) {
            this.urls.put(size, url);
            return this;
        }

        public ImageUrl build() {
            if (this.urls.size() == 1 && this.urls.containsKey(1)) {
                return new SingleImageUrl(this.urls.get(1));
            }
            if (this.id == null) {
                return new MapImageUrl(this.urls);
            }
            String template = null;
            for (Map.Entry<Integer, String> entry : this.urls.entrySet()) {
                int size = entry.getKey();
                String url = entry.getValue();
                String temp = StringUtil.replaceLast(url, this.id, "{id}");
                if (!ImageUrl.buildUrl(temp = StringUtil.replaceLast(temp, String.valueOf(entry.getKey()), "{x}"), this.id, size).equals(url) || template != null && !template.equals(temp)) {
                    return new MapImageUrl(this.urls);
                }
                template = temp;
            }
            ImageUrl result = ImageUrl.cache(new TemplateImageUrl(template, this.urls.keySet()));
            return result;
        }
    }

    public static class SingleImageUrl
    extends ImageUrl {
        private final String url;

        private SingleImageUrl(String url) {
            this.url = url;
        }

        @Override
        public String getUrl(String id, int size) {
            if (size == 1) {
                return this.url;
            }
            return null;
        }
    }

    public static class MapImageUrl
    extends ImageUrl {
        private final Map<Integer, String> urls;

        private MapImageUrl(Map<Integer, String> urls) {
            this.urls = urls;
        }

        @Override
        public String getUrl(String id, int size) {
            return this.urls.get(size);
        }
    }
}

