/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.DateTime;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONUtil {
    public static String getString(JSONObject data, Object key, String errorValue) {
        Object value = data.get(key);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return errorValue;
    }

    public static String getString(JSONObject data, Object key) {
        return JSONUtil.getString(data, key, null);
    }

    public static List<String> getStringList(JSONObject data, Object key) {
        Object value = data.get(key);
        if (value != null && value instanceof JSONArray) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object item : (JSONArray)value) {
                if (!(item instanceof String)) continue;
                result.add((String)item);
            }
            return result;
        }
        return null;
    }

    public static int getInteger(JSONObject data, Object key, int errorValue) {
        Object value = data.get(key);
        if (value != null && value instanceof Number) {
            return ((Number)value).intValue();
        }
        return errorValue;
    }

    public static int parseInteger(JSONObject data, Object key, int errorValue) {
        try {
            return Integer.parseInt((String)data.get(key));
        }
        catch (Exception ex) {
            return errorValue;
        }
    }

    public static long parseLong(JSONObject data, Object key, long errorValue) {
        try {
            return Long.parseLong((String)data.get(key));
        }
        catch (Exception ex) {
            return errorValue;
        }
    }

    public static long getLong(JSONObject data, Object key, long errorValue) {
        Object value = data.get(key);
        if (value != null && value instanceof Number) {
            return ((Number)value).longValue();
        }
        return errorValue;
    }

    public static boolean getBoolean(JSONObject data, Object key, boolean errorValue) {
        Object value = data.get(key);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return errorValue;
    }

    public static JSONObject getOrEmpty(JSONObject data, Object key) {
        Object value = data.get(key);
        if (value != null && value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return new JSONObject();
    }

    public static String listToJSON(Object ... args) {
        JSONArray o = new JSONArray();
        for (Object a : args) {
            o.add(a);
        }
        return o.toJSONString();
    }

    public static String listMapToJSON(Object ... args) {
        JSONObject m = new JSONObject();
        for (int i = 0; i < args.length; i += 2) {
            m.put(args[i], i + 1 < args.length ? args[i + 1] : null);
        }
        return m.toJSONString();
    }

    public static JSONObject listMapToJSONObject(Object ... args) {
        JSONObject m = new JSONObject();
        for (int i = 0; i < args.length; i += 2) {
            m.put(args[i], i + 1 < args.length ? args[i + 1] : null);
        }
        return m;
    }

    public static long getDatetime(JSONObject data, Object key, long errorValue) {
        Object value = data.get(key);
        if (value != null && value instanceof String) {
            try {
                return DateTime.parseDatetime((String)value);
            }
            catch (IllegalArgumentException ex) {
                return errorValue;
            }
        }
        return errorValue;
    }
}

