/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.gui.GuiUtil;
import chatty.util.colors.ColorCorrectionNew;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumbers
extends JPanel {
    private static final int MIN_DIGITS = 2;
    private static final int HEIGHT = 20000000;
    private static final int PADDING_LEFT = 4;
    private static final int PADDING_RIGHT = 5;
    private final JTextComponent comp;
    private int prevHeight;
    private int prevDigitCount;
    private Font prevFont;

    public LineNumbers(JTextComponent comp) {
        this.comp = comp;
        comp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LineNumbers.this.documentUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LineNumbers.this.documentUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LineNumbers.this.documentUpdated();
            }
        });
        comp.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName() == null) {
                return;
            }
            switch (evt.getPropertyName()) {
                case "font": {
                    this.setFont(comp.getFont());
                    this.updateSize();
                    break;
                }
                case "background": 
                case "foregorund": {
                    this.updateColors();
                }
            }
        });
        this.setFont(comp.getFont());
        this.updateColors();
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 5));
        this.updateSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        int startLine;
        Element row;
        super.paintComponent(g);
        Document doc = this.comp.getDocument();
        Insets insets = this.getInsets();
        int availableWidth = this.getWidth() - insets.left - insets.right;
        int descent = g.getFontMetrics().getDescent();
        Rectangle clip = g.getClipBounds();
        int startOffset = this.comp.viewToModel(new Point(0, clip.y));
        int endOffset = this.comp.viewToModel(new Point(clip.x + clip.width, clip.y + clip.height));
        for (int i = startLine = doc.getDefaultRootElement().getElementIndex(startOffset); i < doc.getDefaultRootElement().getElementCount() && (row = doc.getDefaultRootElement().getElement(i)).getStartOffset() <= endOffset; ++i) {
            try {
                Rectangle r = this.comp.modelToView(row.getStartOffset());
                String number = String.valueOf(i + 1);
                int numberWidth = g.getFontMetrics().stringWidth(number);
                int pos = availableWidth - numberWidth + insets.left;
                g.drawString(number, pos, r.y + r.height - descent);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void documentUpdated() {
        SwingUtilities.invokeLater(() -> {
            try {
                int endPos = this.comp.getDocument().getLength();
                Rectangle rect = this.comp.modelToView(endPos);
                if (rect != null && rect.y != this.prevHeight) {
                    this.updateSize();
                    this.getParent().repaint();
                    this.prevHeight = rect.y;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    private void updateColors() {
        this.setForeground(ColorCorrectionNew.offset(this.comp.getForeground(), 0.65f));
        this.setBackground(this.comp.getBackground());
    }

    private void updateSize() {
        Element root = this.comp.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digitCount = Math.max(String.valueOf(lines).length(), 2);
        Font font = this.getFont();
        if (this.prevDigitCount != digitCount || this.prevFont != font) {
            this.prevDigitCount = digitCount;
            this.prevFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int width = fontMetrics.charWidth('0') * digitCount;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 20000000);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            frame.setLocationRelativeTo(null);
            JTextArea text = new JTextArea();
            frame.setLayout(new GridBagLayout());
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setMargin(new Insets(2, 2, 2, 2));
            text.setFont(Font.decode("Monospaced"));
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < 100; ++i) {
                b.append("test text" + i);
                if (ThreadLocalRandom.current().nextInt(4) != 0) continue;
                b.append("\n");
            }
            text.setText(b.toString());
            text.setMargin(new Insets(1, 3, 1, 3));
            JScrollPane scroll = new JScrollPane(text);
            scroll.setRowHeaderView(new LineNumbers(text));
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 3, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(5, 7, 5, 7);
            frame.add((Component)scroll, gbc);
            frame.setSize(400, 300);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        });
    }
}

