/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Livestreamer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(Livestreamer.class.getName());
    private final String command;
    private final LivestreamerListener listener;
    private Process process;

    public Livestreamer(String command, LivestreamerListener listener) {
        this.command = command;
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            Process process;
            Runtime rt = Runtime.getRuntime();
            String[] cmd = Livestreamer.split(this.command);
            this.process = process = rt.exec(cmd);
            LOGGER.info("Livestreamer: Process " + this.id() + " started. [" + Livestreamer.filterToken(this.command) + "]");
            this.listener.processStarted(this.command);
            InputStreamHelper errorStream = new InputStreamHelper(process.getErrorStream());
            InputStreamHelper inputStream = new InputStreamHelper(process.getInputStream());
            errorStream.start();
            inputStream.start();
            int exitValue = process.waitFor();
            errorStream.join(1000L);
            inputStream.join(1000L);
            this.listener.processFinished(exitValue);
            LOGGER.info("Livestreamer: Process " + this.id() + " finished.");
        }
        catch (IOException ex) {
            this.listener.message("Error: " + ex);
            LOGGER.warning("Livestreamer: Error starting process / " + ex);
        }
        catch (InterruptedException ex) {
            this.listener.message("Error: " + ex);
            LOGGER.warning("Livestreamer: " + ex);
        }
    }

    private String id() {
        return Integer.toHexString(this.process.hashCode());
    }

    public void kill() {
        LOGGER.info("Livestreamer: Killing Process " + this.id());
        this.process.destroy();
    }

    private static String[] split(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("\"([^\"]*)\"|([^\"\\s]+)").matcher(input);
        while (m.find()) {
            if (m.group(1) != null) {
                result.add(m.group(1));
                continue;
            }
            result.add(m.group(2));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String filterToken(String input) {
        return input.replaceAll("--twitch-oauth-token \\w+", "--twitch-oauth-token <token>");
    }

    public static final void main(String[] args) {
        System.out.println(Livestreamer.filterToken("--twitch-oauth-token abcfwf --fwaf"));
    }

    public static interface LivestreamerListener {
        public void processStarted(String var1);

        public void message(String var1);

        public void processFinished(int var1);
    }

    private class InputStreamHelper
    extends Thread {
        private final InputStream input;

        InputStreamHelper(InputStream input) {
            this.input = input;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Livestreamer.this.listener.message(line);
                    LOGGER.info("Livestreamer (" + Livestreamer.this.id() + "): " + line);
                }
            }
            catch (IOException ex) {
                Livestreamer.this.listener.message("Error: " + ex);
                LOGGER.warning("Livestreamer (" + Livestreamer.this.id() + "): Error reading stream / " + ex);
            }
        }
    }
}

