/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.Helper;
import chatty.util.ElapsedTime;
import chatty.util.StringUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class LogUtil {
    private static final Logger LOGGER = Logger.getLogger(LogUtil.class.getName());
    private static final AtomicInteger EDT_LOCK_STATE = new AtomicInteger();
    private static final ElapsedTime EDT_LOCK_LAST_LOGGED = new ElapsedTime();

    public static void logMemoryUsage() {
        LOGGER.info(LogUtil.getMemoryUsage());
    }

    public static String getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return String.format("[Memory] max: %2$,d / %1$,d free: %3$,d (%5$,d%% full) [Uptime] %4$s", runtime.maxMemory() / 1024L, runtime.totalMemory() / 1024L, runtime.freeMemory() / 1024L, Chatty.uptime(), LogUtil.getMemoryPercentageOfMax());
    }

    public static int getMemoryPercentageOfMax() {
        Runtime runtime = Runtime.getRuntime();
        long used = runtime.totalMemory() - runtime.freeMemory();
        return (int)(used * 100L / runtime.maxMemory());
    }

    public static String getAppInfo() {
        return Chatty.chattyVersion() + " " + LogUtil.getMemoryUsage() + " [System] " + Helper.systemInfo();
    }

    public static void startMemoryUsageLogging() {
        Timer t = new Timer(true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                LogUtil.logMemoryUsage();
            }
        }, 10000L, 900000L);
    }

    public static void logDeadlocks() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (!bean.isSynchronizerUsageSupported()) {
            LOGGER.warning("Unable to find deadlocks, synchronizer usage is not supported");
            return;
        }
        long[] threadIds = bean.findDeadlockedThreads();
        if (threadIds != null) {
            ThreadInfo[] infos;
            for (ThreadInfo info : infos = bean.getThreadInfo(threadIds)) {
                StackTraceElement[] stack = info.getStackTrace();
                StringBuilder b = new StringBuilder();
                for (StackTraceElement e : stack) {
                    b.append(e);
                    b.append("\n");
                }
                LOGGER.warning("Deadlock detected: " + b.toString());
            }
        } else {
            LOGGER.info("No deadlocks detected");
        }
    }

    public static void startDeadlockDetection() {
        LOGGER.info("Started Thread Deadlock Detection");
        Timer t = new Timer(true);
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                LogUtil.logDeadlocks();
            }
        }, 10000L, 60000L);
    }

    public static void startEdtLockDetection() {
        Thread thread = new Thread(() -> {
            int state = 0;
            try {
                while (true) {
                    Thread.sleep(30000L);
                    int toSet = ++state;
                    SwingUtilities.invokeLater(() -> EDT_LOCK_STATE.set(toSet));
                    Thread.sleep(1000L);
                    if (EDT_LOCK_STATE.get() == state || !EDT_LOCK_LAST_LOGGED.secondsElapsed(600)) continue;
                    EDT_LOCK_LAST_LOGGED.set();
                    LOGGER.warning("EDT may be slow");
                    LogUtil.logThreadInfo();
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }, "EdtLockDetection");
        thread.setDaemon(true);
        thread.start();
    }

    public static void logThreadInfo() {
        LOGGER.info("Thread Dump:\n" + LogUtil.threadDump());
        LogUtil.logDeadlocks();
    }

    public static String threadDump() {
        ThreadInfo[] threadInfo;
        StringBuilder b = new StringBuilder();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : threadInfo = threads.dumpAllThreads(threads.isObjectMonitorUsageSupported(), threads.isSynchronizerUsageSupported())) {
            b.append("[");
            b.append(info.getThreadName());
            b.append("/");
            b.append((Object)info.getThreadState());
            if (info.getLockName() != null) {
                b.append("|");
                b.append(info.getLockName());
                b.append("/");
                b.append(info.getLockOwnerName());
            }
            b.append("] ");
            b.append(StringUtil.join(info.getStackTrace()));
            b.append("\n");
        }
        return b.toString();
    }
}

