/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class MiscUtil {
    private static final Logger LOGGER = Logger.getLogger(MiscUtil.class.getName());
    public static final boolean OS_WINDOWS = MiscUtil.checkOS("Windows");
    public static final boolean OS_LINUX = MiscUtil.checkOS("Linux");
    public static final boolean OS_MAC = MiscUtil.checkOS("Mac");

    public static void copyToClipboard(String text) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(new StringSelection(text), null);
    }

    public static boolean openFile(Path folder, Component parent) {
        return MiscUtil.openFile(folder.toString(), parent);
    }

    public static boolean openFile(File file, Component parent) {
        return MiscUtil.openFile(file.toString(), parent);
    }

    public static boolean openFile(String file, Component parent) {
        try {
            Desktop.getDesktop().open(new File(file));
        }
        catch (Exception ex) {
            if (parent != null) {
                JOptionPane.showMessageDialog(parent, "Opening file/folder failed.\n" + ex.getLocalizedMessage());
            }
            return false;
        }
        return true;
    }

    public static boolean openFilePrompt(String path, Component parent) {
        int chosenOption = JOptionPane.showOptionDialog(parent, path, "Open in default application?", 2, 3, null, new String[]{"Open File", "Cancel"}, 0);
        if (chosenOption == 0) {
            return MiscUtil.openFile(path, parent);
        }
        return false;
    }

    public static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String key = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                key = arg.substring(1);
                result.put(key, "");
                continue;
            }
            if (key == null) continue;
            String newValue = ((String)result.get(key) + " " + arg).trim();
            result.put(key, newValue);
        }
        return result;
    }

    public static void moveFile(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ex) {
            LOGGER.info("ATOMIC_MOVE failed: " + ex);
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static int deleteInDir(File dir, String prefix, boolean deleteDir) {
        File[] files;
        int count = 0;
        if (dir.isDirectory() && null != (files = dir.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    count += MiscUtil.deleteInDir(file, prefix, true);
                    continue;
                }
                if (!file.getName().startsWith(prefix) || !files[i].delete()) continue;
                ++count;
            }
        }
        if (deleteDir) {
            dir.delete();
        }
        return count;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static boolean checkOS(String check) {
        String os = System.getProperty("os.name");
        return os.startsWith(check);
    }

    public static long ems() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static boolean biton(int value, int i) {
        return (value & 1 << i) != 0;
    }

    public static Image rotateImage(Image image) {
        BufferedImage bi;
        if (image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        } else {
            bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-image.getWidth(null), -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bi, null);
    }

    public static <T> List<Set<T>> splitSetByLimit(Set<T> original, int limit) {
        if (limit <= 0) {
            limit = 1;
        }
        ArrayList<Set<T>> result = new ArrayList<Set<T>>();
        Iterator<T> it = original.iterator();
        while (it.hasNext()) {
            HashSet<T> part = new HashSet<T>();
            for (int i = 0; i < limit && it.hasNext(); ++i) {
                part.add(it.next());
            }
            result.add(part);
        }
        return result;
    }

    public static <T> void addLimited(Set<T> source, Set<T> target, int limit) {
        for (T item : source) {
            if (target.size() >= limit) {
                return;
            }
            target.add(item);
        }
    }

    public static boolean isBitEnabled(int value, int bit) {
        return (value & bit) != 0;
    }

    public static boolean isBitEnabled(long value, long bit) {
        return (value & bit) != 0L;
    }

    public static <K, V> Set<V> getSetFromMap(Map<K, Set<V>> map, K mapKey) {
        if (!map.containsKey(mapKey)) {
            map.put(mapKey, new HashSet());
        }
        return map.get(mapKey);
    }

    public static boolean exportText(String fileName, String text, boolean append) {
        Path file = Chatty.getPathCreate(Chatty.PathType.EXPORT).resolve(fileName).toAbsolutePath().normalize();
        if (!file.startsWith(Chatty.getPath(Chatty.PathType.EXPORT))) {
            LOGGER.warning("Invalid filename (may contain '..'?): " + fileName);
            return false;
        }
        try {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            if (append) {
                options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, Charset.forName("UTF-8"), options);){
                writer.write(text);
            }
            LOGGER.info(String.format("Written text to file: %s [%s]", file, StringUtil.shortenTo(text, 10)));
            return true;
        }
        catch (IOException ex) {
            LOGGER.warning("Error writing text to file: " + ex);
            return false;
        }
    }

    public static String intern(String input) {
        if (input == null) {
            return null;
        }
        return input.intern();
    }

    public static boolean isNumTrue(Object object) {
        return object instanceof Number && ((Number)object).intValue() == 1;
    }
}

