/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.util.UrlRequest;
import chatty.util.api.CachedManager;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class OtherBadges {
    private static final Logger LOGGER = Logger.getLogger(OtherBadges.class.getName());
    private static final String CACHE_FILE = Chatty.getPathCreate(Chatty.PathType.CACHE).resolve("other_badges").toString();
    public static final int CACHE_EXPIRES_AFTER = 86400;

    public static void requestBadges(final OtherBadgesListener listener, boolean forcedRefresh) {
        CachedManager cache = new CachedManager(CACHE_FILE, 86400L, "Other Badges"){

            @Override
            public boolean handleData(String data) {
                List icons;
                if (data != null && (icons = OtherBadges.parseUsericons(data)) != null) {
                    listener.received(icons);
                    return true;
                }
                return false;
            }
        };
        new Thread(() -> {
            if (forcedRefresh || !cache.load()) {
                String url = "https://tduva.com/res/badges";
                UrlRequest request = new UrlRequest(url);
                request.setLabel("Other Badges");
                request.async((result, responseCode) -> cache.dataReceived(result, forcedRefresh));
            }
        }).start();
    }

    private static List<Usericon> parseUsericons(String json) {
        try {
            ArrayList<Usericon> result = new ArrayList<Usericon>();
            JSONParser parser = new JSONParser();
            JSONArray data = (JSONArray)parser.parse(json);
            for (Object obj : data) {
                JSONObject item = (JSONObject)obj;
                Usericon icon = OtherBadges.parseUsericon(item);
                if (icon == null) continue;
                result.add(icon);
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing third-party badges: " + ex);
            return null;
        }
    }

    private static Usericon parseUsericon(JSONObject data) {
        try {
            String title = (String)data.get("meta_title");
            String id = (String)data.get("id");
            String version = (String)data.get("version");
            String url = (String)data.get("image_url");
            String url2 = (String)data.get("image_url_2");
            String color = (String)data.get("color");
            String metaUrl = (String)data.get("meta_url");
            String position = (String)data.get("position");
            HashSet<String> usernames = new HashSet<String>();
            for (Object obj : (JSONArray)data.get("usernames")) {
                usernames.add((String)obj);
            }
            HashSet<String> userids = new HashSet<String>();
            if (data.containsKey("userids")) {
                for (Object obj : (JSONArray)data.get("userids")) {
                    userids.add((String)obj);
                }
            }
            Usericon icon = UsericonFactory.createThirdParty(id, version, url, url2, title, metaUrl, color, usernames, userids, position);
            return icon;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing third-party badge: " + ex);
            return null;
        }
    }

    public static interface OtherBadgesListener {
        public void received(List<Usericon> var1);
    }
}

