/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.DateTime;
import chatty.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Proc
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(Proc.class.getName());
    private final String command;
    private final ProcListener listener;
    private Process process;
    private final String label;
    private final long created;

    public Proc(String command, ProcListener listener, String label) {
        this.command = command;
        this.listener = listener;
        this.label = label;
        this.created = System.currentTimeMillis();
    }

    public String getCommand() {
        return this.command;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void run() {
        if (this.command == null || this.command.isEmpty()) {
            return;
        }
        String[] cmd = Proc.split(this.command);
        try {
            Process p;
            Runtime rt = Runtime.getRuntime();
            this.process = p = rt.exec(cmd);
            LOGGER.info(String.format("[%s] Process %s started. [%s][%s]", this.label, this.id(), this.command, StringUtil.join(cmd)));
            this.listener.processStarted(this);
            InputStreamHelper errorStream = new InputStreamHelper(p.getErrorStream());
            InputStreamHelper inputStream = new InputStreamHelper(p.getInputStream());
            errorStream.start();
            inputStream.start();
            int exitValue = p.waitFor();
            errorStream.join(1000L);
            inputStream.join(1000L);
            this.listener.processFinished(this, exitValue);
            LOGGER.info(String.format("[%s] Process %s finished.", this.label, this.id()));
        }
        catch (IOException ex) {
            this.listener.message(this, "Error: " + ex);
            LOGGER.warning(String.format("[%s] Error starting process / %s [%s][%s]", this.label, ex, this.command, StringUtil.join(cmd)));
        }
        catch (InterruptedException ex) {
            this.listener.message(this, "Error: " + ex);
            LOGGER.warning(String.format("[%s] %s", this.label, ex));
        }
    }

    private String id() {
        return Integer.toHexString(this.process.hashCode());
    }

    public void kill() {
        LOGGER.info(String.format("[%s] Killing Process %s", this.label, this.id()));
        this.process.destroy();
    }

    @Override
    public String toString() {
        return String.format("[%s] %s (%s)", this.label, this.command, DateTime.agoSingleVerbose(this.created));
    }

    public static String[] split(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("\"((?:\\\\\"|[^\"])+)\"|((?:\\\\\"|[^\"\\s])+)").matcher(input);
        while (m.find()) {
            if (m.group(1) != null) {
                result.add(m.group(1).replace("\\\"", "\""));
                continue;
            }
            result.add(m.group(2).replace("\\\"", "\""));
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String message = "Is there even anything over \"here\"?".replace("\"", "\\\"");
        String test = "notify-send \\\"Title\\\" \"" + message + "\"";
        String[] split = Proc.split(test);
        System.out.println(test);
        System.out.println(Arrays.asList(split));
    }

    public static interface ProcListener {
        public void processStarted(Proc var1);

        public void message(Proc var1, String var2);

        public void processFinished(Proc var1, int var2);
    }

    private class InputStreamHelper
    extends Thread {
        private final InputStream input;

        InputStreamHelper(InputStream input) {
            this.input = input;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Proc.this.listener.message(Proc.this, line);
                    LOGGER.info(String.format("[%s] (%s): %s", Proc.this.label, Proc.this.id(), line));
                }
            }
            catch (IOException ex) {
                Proc.this.listener.message(Proc.this, "Error: " + ex);
                LOGGER.warning(String.format("[%s] (%s): Error reading stream / %s", Proc.this.label, Proc.this.id(), ex));
            }
        }
    }
}

