/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.Helper;
import chatty.util.CachedBulkManager;
import chatty.util.JSONUtil;
import chatty.util.Pair;
import chatty.util.StringUtil;
import chatty.util.UrlRequest;
import chatty.util.api.CachedManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Pronouns {
    private static final Logger LOGGER = Logger.getLogger(Pronouns.class.getName());
    private static final Object LOCK = new Object();
    private volatile Map<String, Pronoun> pronouns = new HashMap<String, Pronoun>();
    private final CachedBulkManager<String, String> data;
    private static volatile Pronouns instance;
    private static final String NOT_FOUND = "__EMPTY_RESULT__";
    private static final String CACHE_FILE1;
    public static final int CACHE_EXPIRES_AFTER = 86400;
    private static final Path CACHE_FILE2;
    private final Object UNIQUE = new Object();
    private long userCounter = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pronouns instance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new Pronouns();
            }
            return instance;
        }
    }

    public Pronouns() {
        this.data = new CachedBulkManager<String, String>(new CachedBulkManager.Requester<String, String>(){

            @Override
            public void request(CachedBulkManager<String, String> manager, Set<String> asap, Set<String> normal, Set<String> backlog) {
                String username = manager.makeAndSetRequested(asap, normal, backlog, 1).iterator().next();
                UrlRequest request = new UrlRequest("https://api.pronouns.alejo.io/v1/users/" + username);
                request.async((result, responseCode) -> {
                    if (responseCode == 404) {
                        manager.setResult(username, Pronouns.NOT_FOUND);
                    } else if (result == null) {
                        manager.setError(username);
                    } else {
                        String pronoun_id = Pronouns.this.parseUser(result);
                        if (pronoun_id == null) {
                            manager.setResult(username, Pronouns.NOT_FOUND);
                        } else {
                            manager.setResult(username, pronoun_id);
                        }
                    }
                });
            }
        }, "[Pronouns] ", 48);
        this.data.setCacheTimes(1, 14, TimeUnit.DAYS);
        this.data.loadCacheFromFile(CACHE_FILE2, input -> {
            String[] split = input.split(",", 2);
            if (split.length == 2) {
                return new Pair<String, String>(split[0], split[1]);
            }
            return null;
        });
        this.requestPronouns();
    }

    public void saveCache() {
        this.data.saveCacheToFile(CACHE_FILE2, (key, item) -> {
            if (NOT_FOUND.equals(item)) {
                return null;
            }
            return key + "," + item;
        });
    }

    public void getUser(BiConsumer<String, String> listener, String username) {
        if (!Helper.isValidStream(username)) {
            return;
        }
        this.data.query(this.UNIQUE, result -> {
            if (this.pronouns.isEmpty()) {
                Timer timer = new Timer(1000, e -> this.sendResult(listener, username, result));
                timer.setRepeats(false);
                timer.start();
            } else {
                this.sendResult(listener, username, result);
            }
        }, 2, (String[])new String[]{username});
    }

    public String getUser2(String username) {
        if (!Helper.isValidStream(username)) {
            return null;
        }
        ++this.userCounter;
        String unique = "user" + this.userCounter % 5L;
        return this.getDisplay(this.data.getOrQuerySingle(unique, null, 0, username));
    }

    private void sendResult(BiConsumer<String, String> listener, String username, CachedBulkManager.Result<String, String> result) {
        String r = this.getDisplay(result.get(username));
        if (r != null) {
            listener.accept(username, r);
        }
    }

    private void requestPronouns() {
        CachedManager cache = new CachedManager(CACHE_FILE1, 86400L, "Pronouns1"){

            @Override
            public boolean handleData(String data) {
                Map parsed = Pronouns.this.parsePronouns(data);
                if (!parsed.isEmpty()) {
                    Pronouns.this.pronouns = parsed;
                    return true;
                }
                return false;
            }
        };
        if (!cache.load()) {
            UrlRequest request = new UrlRequest("https://api.pronouns.alejo.io/v1/pronouns");
            request.async((result, responseCode) -> cache.dataReceived(result, false));
        }
    }

    private Map<String, Pronoun> parsePronouns(String json) {
        HashMap<String, Pronoun> result = new HashMap<String, Pronoun>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            for (Object o : root.values()) {
                JSONObject entry = (JSONObject)o;
                String name = JSONUtil.getString(entry, "name");
                String subject = JSONUtil.getString(entry, "subject");
                String object = JSONUtil.getString(entry, "object");
                if (name == null || subject == null) continue;
                result.put(name, new Pronoun(name, subject, object));
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing pronouns: " + ex);
        }
        return result;
    }

    private String parseUser(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            String id = JSONUtil.getString(root, "pronoun_id");
            String alt_id = JSONUtil.getString(root, "alt_pronoun_id");
            return Pronouns.combineIds(id, alt_id);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing pronouns: " + ex);
            return null;
        }
    }

    private static String combineIds(String id, String altId) {
        if (!StringUtil.isNullOrEmpty(id)) {
            if (!StringUtil.isNullOrEmpty(altId)) {
                return id + "|" + altId;
            }
            return id;
        }
        return null;
    }

    private String getDisplay(String combinedIds) {
        Pronoun pronoun;
        if (combinedIds == null) {
            return null;
        }
        String[] split = combinedIds.split("\\|");
        String id = split[0];
        String altId = null;
        if (split.length == 2) {
            altId = split[1];
        }
        if ((pronoun = this.pronouns.get(id)) != null) {
            return pronoun.getDisplay(this.pronouns.get(altId));
        }
        return null;
    }

    static {
        CACHE_FILE1 = Chatty.getPath(Chatty.PathType.CACHE).resolve("pronouns1").toString();
        CACHE_FILE2 = Chatty.getPath(Chatty.PathType.CACHE).resolve("pronouns2");
    }

    private static class Pronoun {
        public final String id;
        public final String subject;
        public final String object;

        private Pronoun(String id, String subject, String object) {
            this.id = id;
            this.subject = subject;
            this.object = object;
        }

        public String getDisplay() {
            if (StringUtil.isNullOrEmpty(this.object) || this.subject.equals(this.object)) {
                return this.subject;
            }
            return String.format("%s/%s", this.subject, this.object);
        }

        public String getDisplay(Pronoun combineWith) {
            if (combineWith == null || this.equals(combineWith)) {
                return this.getDisplay();
            }
            return String.format("%s/%s", this.subject, combineWith.subject);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pronoun other = (Pronoun)obj;
            return Objects.equals(this.id, other.id);
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.id);
            return hash;
        }
    }
}

