/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.Highlighter;
import chatty.util.StringUtil;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;

public class RepeatMsgHelper {
    private static final String TAGS_KEY = "chatty-repeatmsg-count";
    private final Settings settings;
    private Highlighter.HighlightItem matcher;
    private long time;
    private int minRep;
    private int minLen;
    private float minSim;
    private int method;
    private char[] ignoredChars;

    public RepeatMsgHelper(Settings settings) {
        this.settings = settings;
        settings.addSettingChangeListener((setting, type, value) -> {
            if (setting.startsWith("repeatMsg")) {
                GuiUtil.edt(() -> this.loadSettings());
            }
        });
    }

    public MsgTags check(User user, User localUser, String text, MsgTags tags) {
        if (this.matcher == null) {
            return tags;
        }
        if (text.length() < this.minLen) {
            return tags;
        }
        if (!this.matcher.matches(Highlighter.HighlightItem.Type.REGULAR, text, user, localUser, tags)) {
            return tags;
        }
        int repCount = user.getNumberOfSimilarChatMessages(text, this.method, this.time, this.minSim, this.minLen, this.ignoredChars) + 1;
        if (repCount >= this.minRep) {
            return MsgTags.addTag(tags, TAGS_KEY, String.valueOf(repCount));
        }
        return tags;
    }

    public int getPercentage(User user, String a, String b) {
        if (this.matcher == null) {
            return 0;
        }
        if (a.length() < this.minLen || b.length() < this.minLen) {
            return 0;
        }
        a = StringUtil.prepareForSimilarityComparison(a, this.ignoredChars);
        b = StringUtil.prepareForSimilarityComparison(b, this.ignoredChars);
        float sim = StringUtil.checkSimilarity(a, b, this.minSim, this.method);
        return (int)Math.floor(sim * 100.0f);
    }

    public static int getRepeatMsg(MsgTags tags) {
        String value = tags.get(TAGS_KEY);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public void loadSettings() {
        if (this.settings.getBoolean("repeatMsg")) {
            this.matcher = new Highlighter.HighlightItem(this.settings.getString("repeatMsgMatch"));
            this.time = this.settings.getLong("repeatMsgTime");
            this.minRep = this.settings.getInt("repeatMsgRep");
            this.minSim = (float)this.settings.getLong("repeatMsgSim") / 100.0f;
            this.minLen = this.settings.getInt("repeatMsgLen");
            this.method = this.settings.getInt("repeatMsgMethod");
            this.ignoredChars = StringUtil.getCharsFromString(this.settings.getString("repeatMsgIgnored"));
            if (this.ignoredChars.length == 0) {
                this.ignoredChars = null;
            }
        } else {
            this.matcher = null;
        }
    }
}

