/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Replacer {
    private final String[] replacementValues;
    private final Pattern pattern;

    public Replacer(Map<String, String> replacements) {
        this.replacementValues = new String[replacements.size()];
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        for (String item : replacements.keySet()) {
            try {
                Pattern.compile(item);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("Invalid replacement pattern.", ex);
            }
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append("(").append(item).append(")");
            this.replacementValues[i] = replacements.get(item);
            ++i;
        }
        this.pattern = Pattern.compile(sb.toString());
    }

    public String replace(String input) {
        int lastAppendPos = 0;
        Matcher matcher = this.pattern.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(input, lastAppendPos, matcher.start());
            sb.append(this.getReplacement(matcher));
            lastAppendPos = matcher.end();
        }
        sb.append(input, lastAppendPos, input.length());
        return sb.toString();
    }

    private String getReplacement(Matcher matcher) {
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            if (matcher.group(i) == null) continue;
            return this.replacementValues[--i];
        }
        return null;
    }
}

