/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import chatty.util.StringUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class Replacer2 {
    private static final Pattern NAME_CHECK = Pattern.compile("(CAPITAL|SMALL) ");
    private final Pattern wordsPattern;
    private final Map<String, String> wordsMapping;
    private final Map<Integer, String> charsMapping;
    public static final List<String> LOOKALIKES = Arrays.asList("a # a \ud835\udf70 \ud835\ude70 \uff41 \ud835\uddee \ud835\udc34 \u15c5 \ud835\udc68 \ud835\udea8 \ud835\udd6c \ud835\udcea \ud835\udfaa \ud835\udda0 \u0251 \ud835\udd1e \ud835\ude22 \ud835\udee2 \ud835\ude56 \ud835\udf56 \ud835\udc9c \ud835\udf1c \ud835\udc1a \ud81b\udf40 \ud835\udcd0 \ud835\udf90 \ud835\udc4e \ud835\uddd4 \ud835\udd52 \ud835\ude08 \ud835\udd86 \u13aa \ud835\ude8a \ua4ee \u0430 \ud835\udc00 \u03b1 \ud835\udd04 \ud835\udc82 \ud835\udec2 \ud835\udd38 \u237a \ud835\udcb6 \ud835\udf36 \ud800\udea0 \ud835\udefc \ud835\ude3c \ud835\uddba", "b # b \ud835\uddef \uff42 \ud835\udd6d \u0185 \ud835\ude71 \u044c \ud835\udceb \u13cf \ud835\udc69 \ud835\udea9 \ua4d0 \ud835\udd1f \ud835\udf1d \ud835\ude23 \ud835\udee3 \ud835\udda1 \ud835\ude57 \ud835\udf57 \ud800\ude82 \ud800\udf01 \ud835\uddd5 \ud835\udc1b \ud835\udc4f \ud835\udd53 \ud835\udcd1 \ud835\udf91 \ud835\udd87 \ud835\udd05 \u212c \ud835\ude8b \u15af \ud835\ude09 \u1472 \u03b2 \u0432 \ud835\ude3d \ua7b4 \u13f4 \ud835\udc83 \ud835\udc01 \u15f7 \ud835\udcb7 \ud800\udea1 \ud835\udc35 \ud835\uddbb \ud835\udd39", "c # c \ud835\uddf0 \u0441 \u2102 \ud835\udd6e \uff43 \u1d04 \ud835\ude72 \ud801\udc3d \ud835\udcec \ud835\udc6a \ud835\udd20 \ud835\udc9e \ud835\ude24 \ud835\udda2 \ud835\ude58 \ud800\udf02 \ud835\uddd6 \ua4da \ud835\udc1c \u13df \ud835\udc50 \ud801\udd1c \ud835\udd54 \u2ca5 \ud835\udcd2 \ud835\udd88 \ud835\ude8c \u212d \ud835\ude0a \uabaf \u03f2 \ud835\ude3e \ud835\udc84 \ud83d\udf4c \ud835\udc02 \ud806\udcf2 \ud835\udcb8 \ud806\udce9 \ud800\udea2 \ud835\udc36 \ud835\uddbc \u217d", "d # d \u0501 \ud835\udd6f \ud835\udced \u2145 \ud835\ude73 \u2146 \ud835\uddf1 \ud835\ude25 \ud835\udc6b \ud835\udc9f \ua4d2 \ud835\udc1d \ua4d3 \ud835\udda3 \ud835\udd21 \ud835\uddd7 \ud835\udd55 \u15de \ud835\ude59 \u13a0 \ud835\ude8d \ud835\udcd3 \ud835\udc51 \u13e7 \ud835\udd07 \u15ea \ud835\udc85 \ud835\ude0b \ud835\udd89 \u146f \ud835\ude3f \ud835\uddbd \ud835\udc03 \ud835\udc37 \ud835\udd3b \u217e \ud835\udcb9", "e # e \ud835\udd70 \ud835\udcee \ud835\ude74 \uff45 \ud835\uddf2 \u2147 \ud835\ude26 \ud835\udee6 \ud835\udc6c \ud835\udeac \ud835\udf20 \ud835\udc1e \ud835\udda4 \ud835\udd22 \ud835\uddd8 \ud835\udd56 \ud800\ude86 \ud835\ude5a \ud835\udf5a \ud835\ude8e \ud835\udcd4 \ud835\udf94 \ud835\udc52 \ud835\udd08 \ud835\udc86 \ud835\ude0c \u13ac \u212e \ud835\udd8a \u212f \u2130 \ud835\ude40 \ua4f0 \ud835\uddbe \uab32 \ud806\udcae \ud835\udc04 \u0435 \u03b5 \ud835\udc38 \u2d39 \ud806\udca6 \ud835\udd3c \u04bd \u22ff", "f # f \ud835\udcef \ud835\udc6d \u0584 \ud834\ude13 \ud835\uddf3 \ud835\udd71 \ud806\udca2 \ud835\ude27 \ud835\udda5 \ud835\udc1f \ud835\udd23 \ua798 \ud835\udd57 \ua799 \ud835\udcd5 \ud800\ude87 \ud835\ude5b \u1e9d \u03dd \ua4dd \ud835\uddd9 \ud801\udd25 \ud835\ude8f \ud835\ude0d \ud835\udc53 \ud806\udcc2 \ud835\udc87 \ud835\udc05 \ud835\udd8b \ud835\udfca \ud835\udd09 \ud835\uddbf \u2131 \ud835\udd3d \u15b4 \uab35 \ud835\ude41 \ud835\ude75 \ud835\udcbb \ud800\udea5 \u017f \ud835\udc39", "g # g \ud835\udcf0 \u13c0 \u0581 \ud835\udc6e \u1d83 \ud835\uddf4 \ud835\udd72 \uff47 \ud835\ude28 \u210a \ud835\udda6 \u018d \u050d \ud835\udc20 \ud835\udd24 \ud835\udca2 \ua4d6 \ud835\udd58 \ud835\udcd6 \ud835\ude5c \ud835\uddda \ud835\ude90 \u0261 \ud835\ude0e \ud835\udc54 \ud835\udc88 \ud835\udc06 \ud835\udd8c \ud835\udd0a \ud835\uddc0 \ud835\udd3e \u13f3 \ud835\ude42 \ud835\ude76 \ud835\udc3a", "h # h \ud835\udc6f \u13c2 \ud835\udeae \ud835\udd73 \ud835\udcf1 \uff48 \ud835\udee8 \ud835\udda7 \ud835\udd25 \u210b \u210c \u210d \u210e \ud835\ude29 \u2c8f \ud835\ude5d \ud800\udecf \ud835\udf22 \ud835\udc21 \ud835\udcd7 \ud835\udf96 \ud835\udf5c \ud835\udddb \ud835\udd59 \ud835\ude0f \ud835\udd8d \ud835\ude91 \ua4e7 \ud835\udc07 \ud835\udc89 \u0570 \ud835\udcbd \ud835\ude43 \ud835\uddc1 \u03b7 \ud835\ude77 \ud835\uddf5 \u04bb \u13bb \u157c \ud835\udc3b \u043d", "i # i \ud835\udcf2 \ud835\udfb2 \ua647 \u2148 \uff49 \ud835\udd26 \ud835\ude2a \u04cf \ud835\ude5e \ud835\udea4 \ud835\udc22 \u0456 \ud835\udc56 \u02db \ud835\udd5a \ud835\udd8e \u13a5 \ud835\ude92 \ud806\udcc3 \u0269 \u026a \ud835\udc8a \ud835\udeca \u2170 \u0131 \ud835\udcbe \ud835\udf3e \u2373 \ud835\udf04 \uab75 \ud835\uddc2 \ud835\udf78 \u2139 \u03b9 \ud835\uddf6 \u037a \u1fbe", "j # j \ud835\udcf3 \ud835\udc71 \u2149 \ud835\udd27 \uff4a \ud835\udca5 \ud835\ude2b \u148d \ud835\udda9 \ud835\ude5f \ud835\udddd \ud835\udc23 \u0458 \ud835\udc57 \ua4d9 \ud835\udd5b \ud835\udcd9 \ud835\udd8f \ud835\udd0d \ud835\ude93 \ud835\ude11 \ud835\ude45 \u13ab \ud835\udc8b \ud835\udc09 \ud835\udcbf \ua7b2 \u03f3 \ud835\udc3d \ud835\uddc3 \ud835\udd41 \ud835\uddf7 \ud835\udd75 \ud835\ude79 \u037f", "k # k \ud835\udcf4 \ud835\udc72 \ud835\udeb1 \ud835\udd28 \ud835\udca6 \uff4b \ud835\udf25 \ud835\ude2c \ud835\udeeb \ud835\uddaa \ud835\ude60 \ud835\udf5f \ud835\uddde \ud835\udc24 \u2c95 \u16d5 \ua4d7 \ud835\udc58 \ud835\udd5c \ud835\udcda \ud835\udf99 \ud835\udd90 \ud835\udd0e \ud835\ude94 \ud835\ude12 \u13e6 \u212a \ud835\ude46 \ud835\udc8c \ud801\udd18 \ud835\udc0a \ud835\udcc0 \ud835\udc3e \ud835\uddc4 \ud835\udd42 \ud835\uddf8 \ud835\udd76 \u03ba \u043a \ud835\ude7a", "l # l \ud835\udeb0 \ud835\ude2d \ud835\udda8 \ud835\udc25 \ud835\uddab \ud835\udd29 \u2110 \u2111 \ud800\ude8a \ud800\udf09 \u2112 \u2113 \u2c93 \ud835\udf24 \ud835\udf98 \ud835\ude95 \ud835\udfcf \u2223 \ud835\ude47 \u14aa \ud835\uddc5 \ud835\udd40 \ud835\udc3f \ud835\ude44 \ud835\udd43 \ud835\udcc1 \u03b9 \ud800\udf20 \ud835\udc3c \ud835\udc70 \u01c0 \ud81b\udf16 \u16c1 \ud835\udfed \ud835\udd74 \ud835\udc73 \ud806\udca3 \uff49 \uff4c \ud835\udeea \u04cf \u2d4f \ud835\udddf \u2cd1 \ud835\udf5e \ud835\udd5d \ud835\udfe3 \u0456 \ud835\ude61 \ud835\udcd8 \ud835\udddc \ud835\udcdb \u13de \ud801\udd26 \ud835\udfd9 \ud835\udc59 \ud835\ude10 \ud835\udd0f \ua4e1 \ud835\udc8d \ud835\ude13 \ud835\udd91 \uffe8 \ud83e\udff1 \ud835\udc08 \u0269 \ud834\ude2a \ud835\udc0b \u2170 \u06f1 \ua4f2 \ud81b\udf28 \ud806\udcb2 \ud835\ude78 \ud835\udff7 \ud835\udd77 \ud801\udc43 \ud835\udcf5 | \u217c \u23fd \ud835\ude7b \ud835\uddf9", "m # m \ud835\udeed \ud835\udc74 \ud835\udeb3 \ud835\udf27 \ud800\udf11 \ud835\uddac \uff4d \ud835\udde0 \u16d6 \ud835\udf61 \u2c99 \ud835\udcdc \ud835\udf9b \ua4df \ud835\udd10 \ud835\ude14 \ud835\ude48 \ud800\udeb0 \ud835\udc0c \ud835\udc40 \u15f0 \u2133 \ud835\udd44 \u13b7 \ud835\udd78 \u03fb \ud835\ude7c \u03bc \u043c \u217f", "n # n \ud835\ude2f \ud835\udeee \ud835\uddad \ud835\udeb4 \ud835\udf28 \ud835\udc27 \ud835\udd2b \uff4e \ud835\udca9 \ud835\udd5f \ud835\udcdd \ud835\ude63 \u2115 \ud835\udf62 \ud835\udde1 \ud835\ude97 \ud835\ude15 \u2c9b \ud835\udf9c \ud835\udc5b \ua4e0 \ud835\udc8f \ud835\udc0d \ud835\udd93 \ud835\udd11 \ud835\uddc7 \ud801\udd13 \ud835\ude49 \ud835\ude7d \ud835\udcc3 \ud835\udc41 \u0578 \ud835\udcf7 \ud835\udc75 \u057c \ud835\uddfb \u03bd \ud835\udd79", "o # o \ud835\ude30 \ud806\udce0 \u0c02 \u0c82 \u0d02 \u0d82 \ud835\uddae \u0585 \u3007 \ud835\udc28 \ud800\ude92 \ud806\udcd7 \ud835\udd2c \ud835\udcaa \ud835\udf2a \u1d0f \u1d11 \ud801\udcea \ud835\udf9e \ud835\ude98 \ud806\udcc8 \ud835\ude16 \u101d \u2c9f \ud835\uded0 \u0d20 \u0b20 \ud835\udfce \ud835\uded4 \ud835\uddc8 \ud835\udf48 \ud835\udd46 \ud835\ude4a \ud801\udd16 \ud800\udeab \u2134 \ud835\udf44 \ud835\udc42 \ud835\udfb8 \ud835\udeb6 \ud835\udfbc \uab3d \u043e \u03bf \u1040 \ud835\udef0 \u03c3 \ud835\udfec \uff4f \u0e50 \u0ed0 \ud835\udd60 \ud801\udc2c \u12d0 \ud835\udcde \ud835\ude64 \ud835\udf64 \u2d54 \ud835\udfe2 \ud835\udde2 \ud835\udfd8 \ud835\udc5c \ud835\udc90 \ud835\udf0e \ud835\udc0e \ud835\udd94 \u0be6 \u0a66 \u0966 \u0ae6 \u0c66 \u0ce6 \u0d66 \ud835\udd12 \u09e6 \u0b66 \ud83e\udff0 \ud835\udf0a \ud805\udcd0 \ud835\udf7e \ud835\ude7e \ua4f3 \ud806\udcb5 \u06f5 \ud835\udf82 \ud835\udcf8 \ud835\udff6 \ud835\udc76 \ud801\udcc2 \ud835\uddfc \ud835\udd7a \u10ff", "p # p \ud835\uddaf \ud835\udd2d \ud835\ude31 \ud835\udf2c \ud835\udcab \ud800\ude95 \ud835\udc29 \ud835\udfa0 \u2119 \ud835\ude17 \ud835\udd95 \ud835\udf1a \ud835\ude99 \u2ca3 \ud835\udf54 \ud835\uded2 \ud835\udfc8 \ud835\udf46 \ud835\udcc5 \ud835\ude4b \ud835\uddc9 \ud835\udc43 \ud835\udeb8 \ud835\udfba \u0440 \u03c1 \ud835\udef2 \ud835\udf66 \ud835\ude65 \uff50 \ud835\udee0 \ud835\udcdf \ua4d1 \ud835\udc5d \ud835\udde3 \ud835\udd61 \ud835\udc0f \ud835\udf8e \u13e2 \ud835\udd13 \ud835\udc91 \ud835\udf0c \u146d \ud835\udf80 \u03f1 \ud835\ude7f \ud835\uddfd \u2374 \ud835\udc77 \ud835\udd7b \ud835\udcf9", "q # q \ud835\uddb0 \ud835\udd2e \ud835\ude32 \ud835\ude66 \ud835\udcac \ud835\udc2a \ud835\udce0 \ud835\udc5e \ud835\udde4 \u2d55 \ud835\udd62 \ud835\ude18 \ud835\udd96 \u211a \u051b \ud835\ude9a \ud835\udc10 \u0563 \ud835\udd14 \ud835\udc92 \u0566 \ud835\udcc6 \ud835\ude4c \ud835\uddca \ud835\ude80 \ud835\uddfe \ud835\udc44 \ud835\udc78 \ud835\udd7c \ud835\udcfa", "r # r \ud835\udd2f \uab81 \ud835\ude33 \u2c85 \uab47 \ud835\uddb1 \u1587 \uab48 \ud801\udcb4 \ud835\ude67 \ud835\udde5 \ud835\udc2b \ud835\udc5f \u13d2 \ud835\udd63 \ud835\udce1 \ud835\udd97 \u211b \u211c \ud835\ude9b \u211d \ud835\ude19 \u13a1 \ud81b\udf35 \ud835\ude4d \ua4e3 \ud835\udc93 \u1d26 \u01a6 \ud835\udc11 \ud835\udcc7 \ud835\udc45 \ud835\uddcb \ud835\uddff \u0433 \ud835\udd7d \ud835\ude81 \ud834\ude16 \ud835\udcfb \ud835\udc79", "s # s \ud835\udd30 \ud835\udcae \ud835\ude34 \ud835\uddb2 \ud835\ude68 \ud835\udde6 \ud835\udc2c \ud800\ude96 \ud835\udc60 \uff53 \ud835\udd64 \u0455 \u13d5 \ud835\udce2 \ud835\udd98 \ud835\udd16 \u13da \ud835\ude9c \ud835\ude1a \ud806\udcc1 \ud835\ude4e \ua4e2 \ud835\udc94 \ud81b\udf3a \ud835\udc12 \ud835\udcc8 \uabaa \ud835\udc46 \ud835\uddcc \ud835\udd4a \ud835\ude00 \ua731 \ud835\udd7e \ud835\ude82 \ud835\udcfc \ud801\udc48 \u01bd \ud835\udc7a \u057f", "t # t \ud835\udcaf \ud835\udf2f \u0442 \ud835\udc2d \u03c4 \ud835\uddb3 \ud835\udd31 \ud835\udde7 \ud835\udd65 \ud800\ude97 \ud800\udf15 \ud835\ude69 \ud835\udf69 \ud83d\udf68 \ud835\ude9d \uff54 \ua4d4 \ud81b\udf0a \ud835\udce3 \ud835\udfa3 \ud835\udc61 \u27d9 \ud835\udd17 \ud835\udc95 \ud835\ude1b \ud835\udd99 \ud835\ude4f \u13a2 \ud835\uddcd \u22a4 \ud835\udc13 \u2ca7 \ud835\udc47 \ud800\udeb1 \ud835\udd4b \ud806\udcbc \ud835\udcc9 \ud835\udd7f \ud835\udcfd \ud835\ude83 \ud835\ude01 \ud835\ude35 \ud835\udef5 \ud835\udc7b \ud835\udebb", "u # u \ud835\udcb0 \u1200 \ud835\udc2e \u22c3 \ud835\uddb4 \u03c5 \ud835\udd32 \ud835\udde8 \ud806\udcd8 \ud835\udd66 \u028b \u144c \ud835\ude6a \uab4e \ud801\udcf6 \ud835\ude9e \uab52 \ud835\udce4 \ud835\udc62 \ud835\udd18 \ud835\udc96 \ud835\uded6 \u1d1c \ud835\ude1c \ud81b\udf42 \ud835\udd9a \ua79f \ud835\udf10 \ud835\ude50 \ud835\uddce \ud835\udc14 \ud835\udc48 \ud806\udcb8 \u222a \ud835\udd4c \ud835\udcca \ud835\udf4a \ud835\udd80 \ud835\udcfe \ud835\udfbe \ud835\udf84 \ud835\ude84 \ua4f4 \ud835\ude02 \ud801\udcce \ud835\ude36 \ud835\udc7c \u057d", "v # v \ud835\udc2f \ud835\udd33 \ud835\udcb1 \ud835\ude9f \ud835\ude1d \ud835\udc97 \ud835\udc15 \ud835\udd9b \ud835\udd19 \u1d20 \ud835\uddcf \ud835\udece \ud835\udd4d \ud835\ude51 \ud801\udd1d \u2228 \uaba9 \ud835\udccb \ud835\udc49 \u142f \ud835\udf42 \u2d38 \ud835\ude37 \ud835\udfb6 \ud805\udf06 \ud835\uddb5 \u03bd \u22c1 \ud806\udca0 \ud834\ude0d \ud835\udd67 \ud835\udce5 \ud835\ude6b \ud835\udde9 \ud835\udc63 \uff56 \ud81b\udf08 \u13d9 \ua6df \ud806\udcc0 \ua4e6 \ud835\udf08 \ud835\ude85 \ud835\udcff \ud835\udc7d \u2174 \ud835\ude03 \u0475 \u06f7 \ud835\udd81 \ud835\udf7c", "w # w \ud835\udc30 \uab83 \ud835\udd34 \ud835\udcb2 \ud835\udd68 \ud835\udce6 \ud835\ude6c \ud835\uddea \ud835\udea0 \ud835\ude1e \ud835\udc64 \u13d4 \ud835\udc98 \ud835\udc16 \ud835\udd9c \u051d \ud835\udd1a \ud835\uddd0 \u1d21 \u0461 \u0561 \ud835\udd4e \ud835\ude52 \ud835\ude86 \ua4ea \ud835\udccc \ud835\udc4a \u026f \ud835\udd00 \ud805\udf0f \ud805\udf0e \ud806\udcef \ud835\udc7e \u13b3 \ud835\ude04 \ud835\udd82 \ud835\ude38 \ud835\uddb6 \ud806\udce6 \ud805\udf0a", "x # x \ud835\udcb3 \ud835\udf32 \ud835\udc31 \ud835\udfa6 \ud800\ude90 \ud800\udf17 \ud835\ude1f \ud835\udd9d \ud835\udea1 \ud835\udc17 \ud835\udd1b \ud835\udc99 \ud835\udd4f \ud835\udccd \ud835\ude53 \ud835\uddd1 \u292b \u292c \ud835\udc4b \u2cad \u2a2f \ud800\udeb4 \ud835\udebe \ua7b3 \u16b7 \ud800\udf22 \ud835\uddb7 \ud835\udd35 \ud806\udcec \ud835\ude39 \u1541 \ud835\ude6d \u0445 \u03c7 \ud835\udce7 \ud835\udc65 \ud835\udf6c \ud835\uddeb \ud835\udd69 \u00d7 \uff58 \u2d5d \ud801\udd27 \ud835\ude87 \ud835\ude05 \ua4eb \u166d \u166e \ud835\udc7f \u2573 \ud835\udd83 \ud835\udd01 \ud835\udef8 \u2179 \u157d", "y # y \ud835\udf30 \ud835\udcb4 \ud835\udc32 \u1d8c \ud835\udfac \ud806\udcdc \u028f \ud835\ude20 \ud835\udd9e \ud81b\udf43 \ud835\udfa4 \ud835\udea2 \ud835\udc18 \ud835\udd1c \ud835\udc9a \ud835\udd50 \ud835\udcce \ud835\ude54 \ud835\uddd2 \u2ca9 \u13a9 \ud800\udeb2 \ud835\udc4c \u04af \u03b3 \ud835\udec4 \ud835\udf38 \ud835\uddb8 \ud835\udd36 \ud835\udebc \u213d \u13bd \ud835\ude3a \ud835\ude6e \u0443 \u03c5 \ud806\udca4 \ud835\udf72 \ud835\udce8 \ud835\udc66 \ud835\uddec \ud835\udd6a \ud835\udf6a \u03d2 \uff59 \uab5a \u0263 \u10e7 \ud835\ude88 \ud835\ude06 \ua4ec \ud835\udc80 \ud835\udefe \ud835\udd84 \ud835\udd02 \ud835\udef6 \u1eff", "z # z \ud835\ude6f \ud835\udded \ud835\udead \u13c3 \ud806\udce5 \ud835\udc33 \ud835\udc67 \ud835\udee7 \ud835\udd6b \ud835\udce9 \ud835\udd9f \uab93 \ud835\udea3 \ud835\ude21 \ud835\udf21 \uff5a \ud835\ude55 \ud835\udf95 \ua4dc \ud835\udc9b \ud835\udf5b \ud835\udc19 \ud835\udccf \u1d22 \ud835\udc4d \u2124 \ud835\uddd3 \ud806\udcc4 \u2128 \ud835\ude07 \ud835\udd85 \ud800\udef5 \ud835\ude89 \ud835\udd03 \u03b6 \ud835\udc81 \ud806\udca9 \ud835\udd37 \ud835\udcb5 \ud835\ude3b \ud835\uddb9");
    private static Result testResult;

    public static Replacer2 create(Collection<String> input) {
        StringBuilder wordsRegexBuilder = new StringBuilder();
        HashMap<Integer, String> charsMapping = new HashMap<Integer, String>();
        HashMap<String, String> wordsMapping = new HashMap<String, String>();
        for (String line : input) {
            List<Part> split = Replacer2.parse(line);
            if (split.size() <= 1) continue;
            String target = split.get((int)0).text;
            List<Part> searchList = split.subList(1, split.size());
            LinkedHashSet<String> words = new LinkedHashSet<String>();
            for (Part partItem : searchList) {
                if (!partItem.valid || partItem.text.equals(target)) continue;
                String part = partItem.text;
                if (Replacer2.singleCodepoint(part)) {
                    charsMapping.put(part.codePointAt(0), target);
                    Replacer2.addAdditionalChar(charsMapping, target, part, part.toUpperCase(Locale.ROOT));
                    Replacer2.addAdditionalChar(charsMapping, target, part, part.toLowerCase(Locale.ROOT));
                    continue;
                }
                if (part.isEmpty()) continue;
                words.add(Pattern.quote(part));
                wordsMapping.put(part.toLowerCase(Locale.ROOT), target);
            }
            String wordsRegex = StringUtil.join(words, "|");
            if (wordsRegex.isEmpty()) continue;
            if (wordsRegexBuilder.length() != 0) {
                wordsRegexBuilder.append("|");
            }
            wordsRegexBuilder.append("(").append(wordsRegex).append(")");
        }
        Debugging.println("substRegex", "SubstRegex: %s", wordsRegexBuilder.toString());
        Pattern wordsPattern = Pattern.compile(wordsRegexBuilder.toString(), 66);
        return new Replacer2(wordsPattern, wordsMapping, charsMapping);
    }

    private static void addAdditionalChar(Map<Integer, String> map, String target, String source, String additional) {
        int codepoint;
        if (Replacer2.validChar(target, additional) && !map.containsKey(codepoint = additional.codePointAt(0)) && Replacer2.checkName(codepoint, source.codePointAt(0))) {
            map.put(codepoint, target);
        }
    }

    private static boolean checkName(int codepointA, int codepointB) {
        String a = Character.getName(codepointA);
        String b = Character.getName(codepointB);
        if (a == null || b == null) {
            return false;
        }
        a = NAME_CHECK.matcher(a).replaceAll("");
        b = NAME_CHECK.matcher(b).replaceAll("");
        return a.equals(b);
    }

    private static boolean singleCodepoint(String input) {
        return input.codePointCount(0, input.length()) == 1;
    }

    private static boolean valid(String target, String part) {
        return target.length() <= part.length();
    }

    private static boolean validChar(String target, String part) {
        return Replacer2.valid(target, part) && Replacer2.singleCodepoint(part);
    }

    public static List<Part> parse(String input) {
        ArrayList<Part> result = new ArrayList<Part>();
        String[] split = input.split(" ");
        boolean combine = false;
        String target = null;
        for (String part : split) {
            if (result.isEmpty()) {
                target = part;
                result.add(new Part(part, false, true));
                continue;
            }
            if (part.equals("#")) {
                combine = !combine;
                continue;
            }
            if (combine && part.codePointCount(0, part.length()) == 1) {
                String character = part;
                result.add(new Part(part, false, Replacer2.valid(target, part)));
                for (String generated : Replacer2.generateDiacritics(character)) {
                    result.add(new Part(generated, true, Replacer2.valid(target, part)));
                }
                continue;
            }
            result.add(new Part(part, false, Replacer2.valid(target, part)));
        }
        return result;
    }

    private Replacer2(Pattern wordsPattern, Map<String, String> wordsMapping, Map<Integer, String> charsMapping) {
        this.wordsPattern = wordsPattern;
        this.wordsMapping = wordsMapping;
        this.charsMapping = charsMapping;
    }

    public String toString() {
        return String.format("%s", this.wordsPattern);
    }

    public Result replace(String message) {
        Result charsResult = this.replaceChars(message);
        if (charsResult != null) {
            message = charsResult.changedText;
        }
        Result wordsResult = this.replaceWords(message);
        if (charsResult == null) {
            return wordsResult;
        }
        if (wordsResult == null) {
            return charsResult;
        }
        TreeMap<Integer, Integer> offsets = new TreeMap<Integer, Integer>();
        for (Map.Entry entry : charsResult.offsets.entrySet()) {
            int index = (Integer)entry.getKey();
            int offset = (Integer)entry.getValue();
            int prevOffsets = 0;
            int minIndex = 0;
            for (Map.Entry entry2 : wordsResult.offsets.entrySet()) {
                int index2 = (Integer)entry2.getKey();
                int offset2 = (Integer)entry2.getValue();
                int origStart = index2 + prevOffsets;
                if (origStart >= index) break;
                prevOffsets += offset2;
                minIndex = index2;
            }
            index = Math.max(minIndex, index - prevOffsets);
            offsets.put(index, offset);
        }
        for (Map.Entry entry2 : wordsResult.offsets.entrySet()) {
            int index2 = (Integer)entry2.getKey();
            int offset2 = (Integer)entry2.getValue();
            if (offsets.containsKey(index2)) {
                offset2 += ((Integer)offsets.get(index2)).intValue();
            }
            offsets.put(index2, offset2);
        }
        return new Result(wordsResult.changedText, offsets);
    }

    public Result replaceChars(String message) {
        if (this.charsMapping.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Integer> offsets = null;
        IntStream codePoints = message.codePoints();
        StringBuilder b = new StringBuilder();
        int index = 0;
        for (int codePoint : codePoints.toArray()) {
            int charCount = Character.charCount(codePoint);
            String target = this.charsMapping.get(codePoint);
            if (target != null) {
                b.append(target);
                int lengthDiff = charCount - target.length();
                if (lengthDiff != 0) {
                    if (offsets == null) {
                        offsets = new TreeMap<Integer, Integer>();
                    }
                    Replacer2.updateOffsets(offsets, index + target.length() - 1, lengthDiff);
                }
            } else {
                b.appendCodePoint(codePoint);
            }
            index += charCount;
        }
        return new Result(b.toString(), offsets);
    }

    public Result replaceWords(String message) {
        if (this.wordsMapping.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Integer> offsets = null;
        Matcher m = this.wordsPattern.matcher(message);
        StringBuilder b = null;
        int lastAppendPos = 0;
        while (m.find()) {
            if (b == null) {
                b = new StringBuilder();
            }
            b.append(message, lastAppendPos, m.start());
            String base = this.wordsMapping.get(m.group().toLowerCase(Locale.ROOT));
            if (base == null) {
                return null;
            }
            int lengthDiff = m.group().length() - base.length();
            if (lengthDiff != 0) {
                if (offsets == null) {
                    offsets = new TreeMap<Integer, Integer>();
                }
                Replacer2.updateOffsets(offsets, m.start() + base.length() - 1, lengthDiff);
            }
            b.append(base);
            lastAppendPos = m.end();
        }
        if (b == null) {
            return null;
        }
        b.append(message, lastAppendPos, message.length());
        return new Result(b.toString(), offsets);
    }

    private static void updateOffsets(Map<Integer, Integer> offsets, int index, int diff) {
        int prevOffset = 0;
        for (Map.Entry<Integer, Integer> entry : offsets.entrySet()) {
            if (index <= entry.getKey()) continue;
            prevOffset += entry.getValue().intValue();
        }
        offsets.put(index - prevOffset, diff);
    }

    private static Collection<String> generateDiacritics(String character) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (int i = 768; i <= 879; ++i) {
            String combined = Normalizer.normalize(character + new String(Character.toChars(i)), Normalizer.Form.NFC);
            if (!Replacer2.singleCodepoint(combined)) continue;
            result.add(combined);
        }
        return result;
    }

    public static void main(String[] args) {
        Replacer2 item = Replacer2.create(Arrays.asList("a @ \ud835\udc9c \u0430", "t \ud835\udcaf", "t test", "hattrick hhat hat", "o ()"));
        String message = "hh\ud835\udc9ct testi\ud835\udc9cbc bac\ud835\udc9c hat \u0410bc";
        System.out.println("'" + message + "'");
        Result result = item.replace(message);
        System.out.println(result);
        Pattern testPattern = Pattern.compile("testi\ud835\udc9cbc");
        Matcher m = testPattern.matcher(message);
        if (m.find()) {
            int start = m.start();
            int end = m.end();
            System.out.println("Range: " + start + "-" + end);
            System.out.println("'" + message.substring(start, end) + "'");
            int start2 = result.indexToChanged(start);
            int end2 = result.indexToChanged(end);
            System.out.println("'" + result.changedText.substring(start2, end2) + "' Converted Range: " + start2 + "-" + end2);
        }
        List<String> data = LOOKALIKES;
        Replacer2 fullItem = Replacer2.create(data);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            for (String line : data) {
                testResult = fullItem.replace("ab ewf waef awef weaf\u2124 awef awe fawef awe fawe fawef");
                testResult = fullItem.replace(line);
            }
        }
        System.out.println(System.currentTimeMillis() - startTime);
    }

    public static class Part {
        public final String text;
        public final boolean autoGenerated;
        public final boolean valid;

        public Part(String text, boolean autoGenerated, boolean invalid) {
            this.text = text;
            this.autoGenerated = autoGenerated;
            this.valid = invalid;
        }
    }

    public static class Result {
        private static final Map<Integer, Integer> EMPTY = new HashMap<Integer, Integer>();
        private final String changedText;
        private final Map<Integer, Integer> offsets;

        public Result(String changedText, Map<Integer, Integer> offsets) {
            this.changedText = changedText;
            this.offsets = offsets == null ? EMPTY : offsets;
        }

        public String getChangedText() {
            return this.changedText;
        }

        public int indexToOriginal(int index) {
            return index + this.getOffset(index);
        }

        public int getOffset(int index) {
            if (this.offsets == null) {
                return 0;
            }
            int resultOffset = 0;
            for (Map.Entry<Integer, Integer> entry : this.offsets.entrySet()) {
                int changedIndex = entry.getKey();
                int offset = entry.getValue();
                if (index <= changedIndex) break;
                resultOffset += offset;
            }
            return resultOffset;
        }

        public int indexToChanged(int index) {
            if (this.offsets == null) {
                return 0;
            }
            for (Map.Entry<Integer, Integer> entry : this.offsets.entrySet()) {
                int changedIndex = entry.getKey();
                int offset = entry.getValue();
                if (index <= changedIndex) break;
                index -= offset;
            }
            return index;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("'").append(this.changedText).append("'").append(this.offsets);
            b.append("\n ");
            for (int i = 0; i < this.changedText.length(); ++i) {
                if (i % 10 == 0) {
                    b.append("|");
                    continue;
                }
                b.append(i % 10);
            }
            return b.toString();
        }
    }
}

