/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Timer;

public class ReplyManager {
    private static final long DELETE_TIME = TimeUnit.HOURS.toMillis(12L);
    private static final Map<String, List<Reply>> data = new HashMap<String, List<Reply>>();
    private static final Map<String, Long> lastAdded = new HashMap<String, Long>();

    public static synchronized void addReply(String parentMsgId, String threadId, String msgId, String userMsg, String parentUserMsg) {
        if (threadId == null) {
            threadId = ReplyManager.getThreadParentMsgId(parentMsgId);
        }
        if (threadId == null) {
            threadId = parentMsgId;
        }
        if (!data.containsKey(threadId)) {
            data.put(threadId, new ArrayList());
            if (parentUserMsg != null) {
                data.get(threadId).add(new Reply(parentMsgId, parentUserMsg));
            }
        }
        data.get(threadId).add(new Reply(msgId, userMsg));
        lastAdded.put(threadId, System.currentTimeMillis());
    }

    public static synchronized String getThreadParentMsgId(String msgId) {
        if (msgId == null) {
            return null;
        }
        for (Map.Entry<String, List<Reply>> entry : data.entrySet()) {
            for (Reply reply : entry.getValue()) {
                if (!msgId.equals(reply.msgId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static synchronized List<Reply> getReplies(String threadId) {
        List<Reply> list = data.get(threadId);
        if (list == null && (threadId = ReplyManager.getThreadParentMsgId(threadId)) != null) {
            list = data.get(threadId);
        }
        if (list == null) {
            return null;
        }
        return new ArrayList<Reply>(list);
    }

    public static synchronized String getFirstUserMsg(String parentMsgId) {
        List<Reply> list = data.get(parentMsgId);
        if (list != null && !list.isEmpty()) {
            return list.get((int)0).userMsg;
        }
        return null;
    }

    private static synchronized void removeOld() {
        Iterator<Map.Entry<String, Long>> it = lastAdded.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            if (System.currentTimeMillis() - entry.getValue() <= DELETE_TIME) continue;
            it.remove();
            data.remove(entry.getKey());
        }
    }

    static {
        Timer timer = new Timer((int)DELETE_TIME, e -> ReplyManager.removeOld());
        timer.setRepeats(true);
        timer.start();
    }

    public static class Reply {
        public final String msgId;
        public final String userMsg;

        private Reply(String msgId, String userMsg) {
            this.msgId = msgId;
            this.userMsg = userMsg;
        }
    }
}

