/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.CachedBulkManager;
import chatty.util.Debugging;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.swing.Timer;

public class RetryManager {
    private final CachedBulkManager<Object, Boolean> manager = new CachedBulkManager<Object, Boolean>(new CachedBulkManager.Requester<Object, Boolean>(){

        @Override
        public void request(CachedBulkManager<Object, Boolean> manager, Set<Object> asap, Set<Object> normal, Set<Object> backlog) {
            Debugging.println("retry", "request(%s, %s, %s)", asap, normal, backlog);
            Set<Object> keys = manager.makeAndSetRequested(asap, normal, backlog, 1);
            if (keys.isEmpty()) {
                return;
            }
            for (Object key : keys) {
                Consumer f = RetryManager.this.getFunction(key);
                if (f == null) continue;
                f.accept(key);
            }
        }
    }, "[RetryManager] ", 18);
    private final Map<Object, Consumer<Object>> requests = new HashMap<Object, Consumer<Object>>();
    private static final RetryManager INSTANCE = new RetryManager();

    public static RetryManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry(Object key, Consumer<Object> function) {
        Map<Object, Consumer<Object>> map = this.requests;
        synchronized (map) {
            Debugging.println("retry", "retry(%s)", key);
            this.requests.put(key, function);
            this.manager.query(key, r -> this.clearRequest(key), 4, (Object[])new Object[]{key});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Consumer<Object> getFunction(Object key) {
        Map<Object, Consumer<Object>> map = this.requests;
        synchronized (map) {
            return this.requests.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRequest(Object key) {
        Map<Object, Consumer<Object>> map = this.requests;
        synchronized (map) {
            if (!this.manager.hasQueryKey(key)) {
                this.requests.remove(key);
                Debugging.println("retry", "Removed %s [now: %s][%s]", key, this.requests, this.manager.debug());
            } else {
                Debugging.println("retry", "Didn't remove %s [now: %s]", key, this.requests);
            }
        }
    }

    public void setSuccess(Object key) {
        this.manager.setResult(key, Boolean.TRUE);
    }

    public void setNotFound(Object key) {
        this.manager.setNotFound((Object[])new Object[]{key});
    }

    public void setError(Object key) {
        this.manager.setError((Object[])new Object[]{key});
    }

    public static void main(String[] args) throws InterruptedException {
        Debugging.command("retry println cbm");
        RetryManager.getInstance().retry("test", k -> {
            Timer t = new Timer(50, e -> {
                System.out.println("Requesting A " + k);
                if (ThreadLocalRandom.current().nextBoolean()) {
                    RetryManager.getInstance().setError(k);
                } else {
                    System.out.println("A success");
                    RetryManager.getInstance().setSuccess(k);
                }
                System.out.println(RetryManager.getInstance().manager.debug());
            });
            t.setRepeats(false);
            t.start();
        });
        RetryManager.getInstance().retry("test", k -> {
            System.out.println("Requesting B " + k);
            System.out.println(RetryManager.getInstance().manager.debug());
            if (ThreadLocalRandom.current().nextBoolean()) {
                RetryManager.getInstance().setError(k);
            } else {
                System.out.println("B success");
                RetryManager.getInstance().setSuccess(k);
            }
            System.out.println(RetryManager.getInstance().manager.debug());
        });
        Thread.sleep(10000L);
        System.out.println(RetryManager.getInstance().manager.debug());
        Thread.sleep(5000000L);
    }
}

