/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.LinkedList;

public class RingBuffer<T> {
    private final int capacity;
    private final LinkedList<T> data;

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.data = new LinkedList();
    }

    public synchronized void add(T item) {
        this.data.addLast(item);
        if (this.data.size() > this.capacity) {
            this.data.removeFirst();
        }
    }

    public synchronized LinkedList<T> getItems() {
        return new LinkedList<T>(this.data);
    }

    public synchronized String toString() {
        return String.format("[%d]%s", this.capacity, this.data);
    }
}

