/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class SimpleCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleCache.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final String id;
    private final Path file;
    private final long expireTime;
    private final String debugPrefix;

    public SimpleCache(String id, String file, long expireTime) {
        this.id = id;
        this.file = Paths.get(file, new String[0]);
        this.expireTime = expireTime;
        this.debugPrefix = "C[" + id + "]";
    }

    public void save(String data) {
        LOGGER.info(this.debugPrefix + " Cache: Trying to save..");
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, CHARSET, new OpenOption[0]);){
            writer.write(new Long(System.currentTimeMillis() / 1000L).toString() + "\n");
            writer.write(data);
            LOGGER.info(this.debugPrefix + " Cache: Saved");
        }
        catch (IOException ex) {
            LOGGER.warning(this.debugPrefix + " Cache: Error saving [" + ex + "]");
        }
    }

    public String load() {
        return this.load(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String load(boolean loadEvenIfExpired) {
        LOGGER.info(this.debugPrefix + " Cache: Trying to load..");
        try (BufferedReader reader = Files.newBufferedReader(this.file, CHARSET);){
            String line;
            long time = Long.parseLong(reader.readLine());
            long timePassed = System.currentTimeMillis() / 1000L - time;
            if (!loadEvenIfExpired && timePassed > this.expireTime) {
                LOGGER.info(this.debugPrefix + " Cache: Did not load (expired)");
                String string2 = null;
                return string2;
            }
            StringBuilder data = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                data.append(line);
                data.append("\n");
            }
            String string = data.toString();
            return string;
        }
        catch (IOException | NumberFormatException ex) {
            LOGGER.warning(this.debugPrefix + " Cache: Error loading [" + ex + "]");
            return null;
        }
    }
}

