/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class SimpleCache2 {
    private static final Logger LOGGER = Logger.getLogger(SimpleCache2.class.getName());
    private final String debugPrefix;
    private final String id;
    private final long expireTime;
    private final Path file;
    private Function<List<String>, Boolean> handleLinesCallback;
    private Supplier<List<String>> refreshLinesCallback;
    private volatile boolean loadSuccess;
    private volatile boolean cacheInvalid;
    private volatile boolean pendingRefresh;

    public SimpleCache2(String id, String file, long expireTime) {
        this.id = id;
        this.file = Paths.get(file, new String[0]);
        this.expireTime = expireTime;
        this.debugPrefix = "C[" + id + "] Cache: ";
    }

    public void setHandleDataCallback(Function<List<String>, Boolean> callback) {
        this.handleLinesCallback = callback;
    }

    public void setRefreshLinesCallback(Supplier<List<String>> callback) {
        this.refreshLinesCallback = callback;
    }

    public void load() {
        if (this.cacheInvalid || this.loadSuccess) {
            return;
        }
        boolean loadedFromCache = this.loadFromCache(false);
        if (!loadedFromCache) {
            this.refresh();
        }
    }

    public void asyncLoad() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleCache2.this.load();
            }
        }).start();
    }

    private boolean loadFromCache(boolean force) {
        List<String> lines = this.loadFromFile(force);
        if (lines != null && this.handleLinesCallback != null) {
            boolean valid = this.handleLinesCallback.apply(lines);
            if (valid) {
                this.loadSuccess = true;
                return true;
            }
            this.cacheInvalid = true;
        }
        return false;
    }

    public void refresh() {
        if (this.pendingRefresh) {
            return;
        }
        if (this.refreshLinesCallback != null) {
            this.pendingRefresh = true;
            List<String> lines = this.refreshLinesCallback.get();
            boolean valid = this.handleLinesCallback.apply(lines);
            if (valid) {
                this.saveToFile(lines);
                this.loadSuccess = true;
            } else if (!this.loadSuccess) {
                this.loadFromCache(true);
            }
        }
        this.pendingRefresh = false;
    }

    public void asyncRefresh() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleCache2.this.refresh();
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized List<String> loadFromFile(boolean forceLoad) {
        LOGGER.info(this.debugPrefix + "Trying to load..");
        try (BufferedReader reader = Files.newBufferedReader(this.file);){
            long time = Long.parseLong(reader.readLine());
            long timePassed = System.currentTimeMillis() / 1000L - time;
            if (forceLoad || timePassed < this.expireTime) {
                List<String> list = SimpleCache2.getLines(reader);
                return list;
            }
            LOGGER.info(this.debugPrefix + "Expired");
            return null;
        }
        catch (IOException | NumberFormatException ex) {
            this.cacheInvalid = true;
            LOGGER.warning(this.debugPrefix + "Error loading [" + ex + "]");
        }
        return null;
    }

    public static List<String> getLines(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    private synchronized void saveToFile(List<String> lines) {
        LOGGER.info(this.debugPrefix + "Trying to save..");
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            writer.write(Long.toString(System.currentTimeMillis() / 1000L));
            for (String line : lines) {
                writer.write("\n");
                writer.write(line);
            }
            LOGGER.info(this.debugPrefix + "Saved.");
        }
        catch (IOException ex) {
            LOGGER.warning(this.debugPrefix + "Error saving [" + ex + "]");
        }
    }
}

