/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

public class SingleInstance {
    private static final Logger LOGGER = Logger.getLogger(SingleInstance.class.getName());
    private static NewInstanceListener listener;

    public static boolean registerInstance(int port) {
        try {
            final ServerSocket server = new ServerSocket(port, 0, InetAddress.getLoopbackAddress());
            Runnable connectionListener = new Runnable(){

                @Override
                public void run() {
                    while (!server.isClosed()) {
                        try {
                            Socket socket = server.accept();
                            SingleInstance.handleConnection(socket);
                        }
                        catch (IOException ex) {
                            LOGGER.warning("Error: " + ex);
                            break;
                        }
                    }
                }
            };
            new Thread(connectionListener).start();
            LOGGER.info("Registered port " + port);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private static void handleConnection(Socket socket) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));){
            int character;
            StringBuilder b = new StringBuilder();
            while ((character = reader.read()) != -1) {
                b.append((char)character);
            }
            LOGGER.info(String.format("Received instance message: %s [%s]", b.toString(), socket));
            if (listener != null) {
                listener.newInstance(b.toString());
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Error handling connection: " + ex);
        }
    }

    public static void notifyRunningInstance(int port, String message) {
        try {
            LOGGER.info("Notifying already running instance: " + message);
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            Socket connection = new Socket();
            connection.connect(address, 500);
            try (PrintWriter output = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));){
                output.print(message);
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Error notifying instance: " + ex);
        }
    }

    public static void setNewInstanceListener(NewInstanceListener listener) {
        SingleInstance.listener = listener;
    }

    public static final void main(String[] args) {
        int port = 12345;
        SingleInstance.registerInstance(port);
        SingleInstance.notifyRunningInstance(port, "{\"channel\":\"test\"}");
        NewInstanceListener listener = new NewInstanceListener(){

            @Override
            public void newInstance(String message) {
                System.out.println(message);
            }
        };
        SingleInstance.setNewInstanceListener(listener);
    }

    public static interface NewInstanceListener {
        public void newInstance(String var1);
    }
}

