/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SpecialMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final Supplier<V> valueCreator;
    private V optional;

    public SpecialMap(Map<K, V> map, Supplier<V> valueCreator) {
        this.map = map;
        this.valueCreator = valueCreator;
    }

    public V getPut(K key) {
        if (!this.containsKey(key)) {
            this.put(key, this.valueCreator.get());
        }
        return this.get(key);
    }

    public V getOptional(K key) {
        if (!this.containsKey(key)) {
            if (this.optional == null) {
                this.optional = this.valueCreator.get();
            }
            return this.optional;
        }
        return this.get(key);
    }

    public void removeEmptyValues() {
        Iterator<Map.Entry<K, V>> it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            V value = it.next().getValue();
            if (value instanceof Map && ((Map)value).isEmpty()) {
                it.remove();
                continue;
            }
            if (!(value instanceof Collection) || !((Collection)value).isEmpty()) continue;
            it.remove();
        }
    }

    public int subSize() {
        int total = 0;
        for (V value : this.map.values()) {
            if (value instanceof Map) {
                total += ((Map)value).size();
                continue;
            }
            if (!(value instanceof Collection)) continue;
            total += ((Collection)value).size();
        }
        return total;
    }

    public boolean subIsEmpty() {
        return this.subSize() == 0;
    }

    public void subRemoveValue(Object o) {
        for (V value : this.map.values()) {
            if (value instanceof Map) {
                ((Map)value).values().remove(o);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            ((Collection)value).remove(o);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }
}

