/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Helper;
import chatty.gui.UrlOpener;
import chatty.gui.components.Channel;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;

public class Speedruncom {
    private final TwitchApi twitchApi;

    public Speedruncom(TwitchApi twitchApi) {
        this.twitchApi = twitchApi;
    }

    public void openCurrentGame(Channel chan) {
        StreamInfo info;
        if (Helper.isRegularChannel(chan.getStreamName()) && (info = this.twitchApi.getStreamInfo(chan.getStreamName(), null)).isValid() && !info.getGame().isEmpty()) {
            String game = info.getGame();
            UrlOpener.openUrlPrompt(chan, "https://speedrun.com/" + Speedruncom.replaceForUrl(game));
            return;
        }
        UrlOpener.openUrlPrompt(chan, "https://speedrun.com");
    }

    private static String replaceForUrl(String game) {
        return game.replaceAll(" ", "_").replaceAll(":", "").replaceAll("'", "").replaceAll("&", "and");
    }
}

