/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.Helper;
import chatty.Logging;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.util.DateTime;
import chatty.util.ElapsedTime;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StreamHighlightHelper {
    private static final Logger LOGGER = Logger.getLogger(StreamHighlightHelper.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String FILE_NAME = "stream_highlights.txt";
    private final Settings settings;
    private final TwitchApi api;
    private final Path file;
    private long lastStreamStartWritten = -1L;
    private final Map<String, ElapsedTime> highlightLastAdded = new HashMap<String, ElapsedTime>();

    public StreamHighlightHelper(Settings settings, TwitchApi api) {
        this.settings = settings;
        this.api = api;
        this.file = Chatty.getPathCreate(Chatty.PathType.EXPORT).resolve(FILE_NAME);
    }

    public String modCommand(User user, String line, MsgTags tags) {
        String channel = user.getOwnerChannel();
        String settingChannel = Helper.toChannel(this.settings.getString("streamHighlightChannel"));
        if (settingChannel == null || !settingChannel.equalsIgnoreCase(channel)) {
            return null;
        }
        String command = StringUtil.toLowerCase(this.settings.getString("streamHighlightCommand"));
        if (command == null || command.trim().isEmpty()) {
            return null;
        }
        String lcLine = StringUtil.toLowerCase(line);
        if (!lcLine.startsWith(command + " ") && !lcLine.equals(command)) {
            return null;
        }
        String match = this.settings.getString("streamHighlightMatch");
        if (match == null || match.trim().isEmpty()) {
            return null;
        }
        Highlighter.HighlightItem item = new Highlighter.HighlightItem(match);
        if (!item.matches(Highlighter.HighlightItem.Type.REGULAR, line, user, null, tags)) {
            return null;
        }
        String comment = line.substring(command.length()).trim();
        return this.addHighlight(channel, comment, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addHighlight(String channel, String comment, User chatUser) {
        boolean createdMarker;
        if (channel == null || channel.isEmpty() || !Helper.isRegularChannel(channel)) {
            return "Failed adding stream highlight (no channel).";
        }
        if (!this.checkCooldown(channel)) {
            return "Stream highlight not added (cooldown).";
        }
        String rawComment = comment;
        if (comment != null && chatUser != null) {
            comment = "[" + chatUser.getDisplayNick() + "] " + comment;
        }
        String createdMarkerText = (createdMarker = this.addStreamMarker(channel, comment)) ? " (Created Stream Marker)" : "";
        StreamInfo streamInfo = this.api.getStreamInfo(Helper.toStream(channel), null);
        String streamTime = "Stream Time N/A";
        if (streamInfo.isValid() && streamInfo.getOnline()) {
            streamTime = DateTime.ago(streamInfo.getTimeStarted(), new DateTime.Formatting[0]);
        }
        if (comment == null) {
            comment = "";
        }
        comment = comment.trim();
        String line = String.format("%s %s [%s]%s%s", DateTime.fullDateTime(), channel, streamTime, !comment.isEmpty() ? " " + comment : "", createdMarkerText);
        String shortComment = "";
        if (!comment.isEmpty()) {
            shortComment = "(" + StringUtil.shortenTo(comment, 30) + ")";
        }
        Parameters params = Parameters.create("");
        params.put("added", "highlight" + (createdMarker ? "/marker" : ""));
        params.put("addedmarker", createdMarker ? "true" : "");
        params.put("chan", channel);
        params.put("uptime", streamTime);
        params.put("timestamp", DateTime.fullDateTime());
        params.put("comment", shortComment);
        params.put("rawcomment", rawComment);
        params.put("fullcomment", comment.isEmpty() ? "" : "(" + comment + ")");
        if (chatUser != null) {
            params.put("chatuser", chatUser.getRegularDisplayNick());
            params.putObject("user", chatUser);
        }
        if (streamInfo.isValid()) {
            params.putObject("streamInfo", streamInfo);
        }
        if (this.settings.getBoolean("streamHighlightCustomEnabled")) {
            CustomCommand cc = CustomCommand.parse(this.settings.getString("streamHighlightCustom"));
            if (cc.hasError()) {
                return "Failed adding stream highlight (error in custom format)." + createdMarkerText;
            }
            String ccResult = cc.replace(params);
            if (StringUtil.isNullOrEmpty(ccResult)) {
                return "Failed adding stream highlight (empty)." + createdMarkerText;
            }
            line = ccResult;
        }
        StreamHighlightHelper streamHighlightHelper = this;
        synchronized (streamHighlightHelper) {
            boolean success;
            if (streamInfo.getTimeStarted() != this.lastStreamStartWritten && this.settings.getBoolean("streamHighlightExtra")) {
                this.addToFile("-");
            }
            if (success = this.addToFile(line)) {
                this.lastStreamStartWritten = streamInfo.getTimeStarted();
                this.cooldownSetAdded(channel);
                String template = this.settings.getString("streamHighlightResponseMsg");
                CustomCommand cc = CustomCommand.parse(template);
                String result = null;
                if (!cc.hasError()) {
                    result = cc.replace(params);
                }
                if (StringUtil.isNullOrEmpty(StringUtil.trim(result))) {
                    result = CustomCommand.parse(this.settings.getStringDefault("streamHighlightResponseMsg")).replace(params);
                }
                return result;
            }
            return "Failed adding stream highlight (write error)." + createdMarkerText;
        }
    }

    private boolean checkCooldown(String channel) {
        int cooldownSeconds = this.settings.getInt("streamHighlightCooldown");
        if (cooldownSeconds <= 0) {
            return true;
        }
        if (!this.highlightLastAdded.containsKey(channel)) {
            this.highlightLastAdded.put(channel, new ElapsedTime());
        }
        return this.highlightLastAdded.get(channel).secondsElapsedSync(cooldownSeconds);
    }

    private void cooldownSetAdded(String channel) {
        if (this.settings.getInt("streamHighlightCooldown") <= 0 || !this.highlightLastAdded.containsKey(channel)) {
            return;
        }
        this.highlightLastAdded.get(channel).setSync();
    }

    private boolean addToFile(String line) {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, CHARSET, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            w.append(line);
            w.newLine();
        }
        catch (IOException ex) {
            LOGGER.warning("Failed to write stream highlights: " + ex);
            return false;
        }
        return true;
    }

    public String openFile() {
        if (!this.file.toFile().exists()) {
            return "Error opening stream highlights file (not present).";
        }
        if (MiscUtil.openFile(this.file.toFile(), null)) {
            return "Opened stream highlights file in default application.";
        }
        return "Error opening stream highlights file.";
    }

    private boolean addStreamMarker(String channel, String description) {
        if (this.settings.getBoolean("streamHighlightMarker")) {
            this.api.createStreamMarker(Helper.toStream(channel), description, e -> {
                if (e != null) {
                    String errorMessage = String.format("Error adding stream marker for %s (%s)", channel, e);
                    LOGGER.log(Logging.USERINFO, errorMessage);
                    if (this.settings.getBoolean("streamHighlightExtra")) {
                        StreamHighlightHelper streamHighlightHelper = this;
                        synchronized (streamHighlightHelper) {
                            this.addToFile(DateTime.fullDateTime() + " " + errorMessage);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }
}

