/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Helper;
import chatty.util.StringUtil;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.settings.SettingChangeListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamStatusWriter
implements SettingChangeListener {
    private static final Logger LOGGER = Logger.getLogger(StreamStatusWriter.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final Pattern p = Pattern.compile("(\\w+) ([0-9_A-Za-z\\.]+)( online| offline)?( [^\\n]+)?");
    private boolean enabled;
    private final Set<Item> items = new HashSet<Item>();
    private final Set<String> streams = new HashSet<String>();
    private final Path path;
    private final TwitchApi api;

    public StreamStatusWriter(Path path, TwitchApi api) {
        this.path = path;
        this.api = api;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public synchronized void setSetting(String setting) {
        this.items.clear();
        this.streams.clear();
        Matcher m = p.matcher(setting);
        while (m.find()) {
            String content;
            String stream = StringUtil.toLowerCase(m.group(1));
            String file = m.group(2);
            String online = StringUtil.trim(m.group(3));
            boolean forOnline = true;
            if ("offline".equals(online)) {
                forOnline = false;
            }
            content = (content = StringUtil.trim(m.group(4))) == null ? "" : content;
            this.items.add(new Item(stream, file, content, forOnline));
            this.streams.add(stream);
        }
    }

    public synchronized void test() {
        if (this.enabled) {
            for (String stream : this.streams) {
                this.streamStatus(this.api.getStreamInfo(stream, null));
            }
        }
    }

    public synchronized void streamStatus(StreamInfo info) {
        if (this.enabled && info.isValid()) {
            for (Item item : this.items) {
                this.checkItemAndWrite(info, item);
            }
        }
    }

    private boolean checkItemAndWrite(StreamInfo info, Item item) {
        if (item.stream.equalsIgnoreCase(info.getStream()) && (item.forOnline && info.getOnline() || !item.forOnline && !info.getOnline())) {
            this.write(item.file, this.makeContent(info, item.content));
            return true;
        }
        return false;
    }

    private String makeContent(StreamInfo info, String content) {
        content = content.replace("%title", info.getTitle());
        content = content.replace("%game", info.getGame());
        content = content.replace("%viewersf", Helper.formatViewerCount(info.getViewers()));
        content = content.replace("%followersf", Helper.formatViewerCount(info.getFollowerCount()));
        content = content.replace("%subscribersf", Helper.formatViewerCount(info.getSubscriberCount()));
        content = content.replace("%viewers", String.valueOf(info.getViewers()));
        content = content.replace("%followers", String.valueOf(info.getFollowerCount()));
        content = content.replace("%subscribers", String.valueOf(info.getSubscriberCount()));
        return content;
    }

    private void write(String fileName, String content) {
        Path file = this.path.resolve(fileName);
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(file, CHARSET, new OpenOption[0]);){
                writer.write(content);
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Error writing status: " + ex);
        }
    }

    @Override
    public void settingChanged(String setting, int type, Object value) {
        if (setting.equals("statusWriter")) {
            this.setSetting((String)value);
            this.test();
        } else if (setting.equals("enableStatusWriter")) {
            this.enabled = (Boolean)value;
            this.test();
        }
    }

    private static class Item {
        public final String stream;
        public final String file;
        public final String content;
        public final boolean forOnline;

        public Item(String stream, String file, String content, boolean forOnline) {
            this.stream = stream;
            this.file = file;
            this.content = content;
            this.forOnline = forOnline;
        }

        public String toString() {
            return this.stream + "/" + this.file + "/" + this.forOnline + "/" + this.content;
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + Objects.hashCode(this.file);
            hash = 17 * hash + (this.forOnline ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            return this.forOnline == other.forOnline;
        }
    }
}

