/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern LINEBREAK_CHARACTERS = Pattern.compile("[\\r\\n]+");
    public static final String UTF8_BOM = "\ufeff";
    public static final NullComparator NULL_COMPARATOR = new NullComparator();

    public static List<String> getStringList(Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        if (obj instanceof List) {
            for (Object item : (List)obj) {
                if (!(item instanceof String)) continue;
                result.add((String)item);
            }
        }
        return result;
    }

    public static String join(String[] array) {
        return StringUtil.join(Arrays.asList(array), ",");
    }

    public static String join(Object[] array) {
        return StringUtil.join(Arrays.asList(array), ",");
    }

    public static String join(Object[] array, String delimiter) {
        return StringUtil.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<?> items, String delimiter) {
        return StringUtil.join(items, delimiter, -1, -1);
    }

    public static String join(Collection<?> items, String delimiter, Function<Object, String> func) {
        return StringUtil.join(items, delimiter, -1, -1, func);
    }

    public static String join(Collection<?> items, String delimiter, int start) {
        return StringUtil.join(items, delimiter, start, -1);
    }

    public static String join(Collection<?> items, String delimiter, int start, int end) {
        return StringUtil.join(items, delimiter, start, end, null);
    }

    public static String join(Collection<?> items, String delimiter, int start, int end, Function<Object, String> func) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        start = start > -1 ? start : 0;
        end = end > -1 ? end : items.size();
        StringBuilder b = new StringBuilder();
        Iterator<?> it = items.iterator();
        int i = 0;
        while (it.hasNext()) {
            String next;
            String string = next = func != null ? func.apply(it.next()) : it.next().toString();
            if (i >= start && i < end) {
                b.append(next);
                if (it.hasNext() && i + 1 < end) {
                    b.append(delimiter);
                }
            }
            ++i;
        }
        return b.toString();
    }

    public static String shortenTo(String input, int max) {
        if (input != null && input.length() > Math.abs(max)) {
            if (max > 2) {
                return input.substring(0, max - 2) + "..";
            }
            if (max < -2) {
                return ".." + input.substring(input.length() + max + 2);
            }
            return "..";
        }
        return input;
    }

    public static String shortenTo(String input, int max, int min) {
        if (input != null && input.length() > max) {
            if (min + 2 > max) {
                min = max - 2;
            }
            if (max > 2) {
                String start = input.substring(0, min);
                String end = input.substring(input.length() - (max - min - 2));
                return start + ".." + end;
            }
            return "..";
        }
        return input;
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String nullToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(Locale.ENGLISH) : null;
    }

    public static String firstToUpperCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1);
    }

    public static String trimAll(String s) {
        if (s == null) {
            return s;
        }
        return StringUtil.removeDuplicateWhitespace(s).trim();
    }

    public static String removeDuplicateWhitespace(String text) {
        return WHITESPACE.matcher(text).replaceAll(" ");
    }

    public static String removeLinebreakCharacters(String s) {
        if (s == null) {
            return null;
        }
        return LINEBREAK_CHARACTERS.matcher(s).replaceAll(" ");
    }

    public static String removeWhitespace(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static String removeWhitespaceAndMore(String input, char[] chars) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c) || chars != null && Arrays.binarySearch(chars, c) >= 0) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static char[] getCharsFromString(String chars) {
        HashSet<Character> unique = new HashSet<Character>();
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (Character.isSurrogate(c)) continue;
            unique.add(Character.valueOf(c));
        }
        char[] result = new char[unique.size()];
        int index = 0;
        for (Character c : unique) {
            result[index] = c.charValue();
            ++index;
        }
        Arrays.sort(result);
        return result;
    }

    public static String append(String a, String sep, String b) {
        if (a == null || a.isEmpty()) {
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        return a + sep + b;
    }

    public static String append(String a, String sep, String bCond, String b) {
        if (a == null || a.isEmpty()) {
            if (!StringUtil.isNullOrEmpty(b)) {
                return bCond + b;
            }
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        if (!StringUtil.isNullOrEmpty(b)) {
            return a + sep + bCond + b;
        }
        return a + sep + b;
    }

    public static boolean isNullOrEmpty(String ... input) {
        if (input == null) {
            return true;
        }
        for (String s : input) {
            if (s != null && !s.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String removeUTF8BOM(String input) {
        if (input != null && input.startsWith(UTF8_BOM)) {
            return input.substring(1);
        }
        return input;
    }

    public static String addLinebreaks(String input, int maxLineLength, boolean html) {
        if (input == null || input.length() <= maxLineLength) {
            return input;
        }
        String[] words = input.split(" ");
        StringBuilder b = new StringBuilder();
        int lineLength = 0;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (b.length() > 0 && lineLength + word.length() > maxLineLength) {
                if (html) {
                    b.append("<br />");
                } else {
                    b.append("\n");
                }
                lineLength = 0;
            } else if (b.length() > 0) {
                b.append(" ");
                ++lineLength;
            }
            b.append(word);
            lineLength += word.length();
        }
        return b.toString();
    }

    public static String aEmptyb(String value, String a, String b) {
        if (value == null || value.isEmpty()) {
            return a;
        }
        return String.format(b, value);
    }

    public static String concats(Object ... args) {
        return StringUtil.concat(" ", args);
    }

    public static String concat(String sep, Object ... args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean appended = false;
        for (Object arg : args) {
            if (appended) {
                b.append(sep);
                appended = false;
            }
            if (arg == null) continue;
            b.append(arg.toString());
            appended = true;
        }
        return b.toString();
    }

    public static List<String> split(String input, char splitAt, int limit) {
        return StringUtil.split(input, splitAt, '\"', '\\', limit, 1);
    }

    public static List<String> split(String input, char splitAt, int limit, int remove) {
        return StringUtil.split(input, splitAt, '\"', '\\', limit, remove);
    }

    public static List<String> split(String input, char splitAt, char quote, char escape, int limit, int remove) {
        if (input == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        boolean quoted = false;
        boolean escaped = false;
        int consecQuotes = 0;
        if ((limit = Math.abs(limit)) == 0) {
            limit = Integer.MAX_VALUE;
        }
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            consecQuotes = c == quote ? ++consecQuotes : 0;
            if (escaped) {
                b.append(c);
                escaped = false;
                continue;
            }
            if (c == escape && escape != quote) {
                escaped = true;
                if (remove != 0) continue;
                b.append(c);
                continue;
            }
            if (c == quote) {
                boolean bl = quoted = !quoted;
                if (remove != 0 && (escape != quote || consecQuotes % 2 != 0)) continue;
                b.append(c);
                continue;
            }
            if (c == splitAt && !quoted && result.size() + 1 < limit) {
                result.add(b.toString());
                b = new StringBuilder();
                if (result.size() + 1 != limit || remove >= 2) continue;
                result.add(input.substring(i + 1));
                return result;
            }
            b.append(c);
        }
        result.add(b.toString());
        return result;
    }

    public static String[] splitLines(String input) {
        return input.split("\r\n|\n|\r");
    }

    public static String quote(String input) {
        return StringUtil.quote(input, "\"");
    }

    public static String quote(String input, String quote) {
        if (input == null) {
            return null;
        }
        return quote + input.replaceAll(Pattern.quote(quote), quote + quote) + quote;
    }

    public static String stringFromInputStream(InputStream inputStream) {
        return StringUtil.stringFromInputStream(inputStream, "UTF-8");
    }

    public static String stringFromInputStream(InputStream inputStream, String charset) {
        String string;
        block9: {
            InputStream input = inputStream;
            try {
                int length;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = input.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                string = result.toString(charset);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            input.close();
        }
        return string;
    }

    public static String randomString(String[] input) {
        if (input.length == 0) {
            return null;
        }
        return input[ThreadLocalRandom.current().nextInt(input.length)];
    }

    public static int getLength(String content) {
        if (content == null) {
            return 0;
        }
        return content.length();
    }

    public static String substring(String input, int start, int end, String fallback) {
        try {
            return input.substring(start, end);
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    public static String replaceFunc(String input, String regex, Function<Matcher, String> func) {
        return StringUtil.replaceFunc(input, Pattern.compile(regex), func);
    }

    public static String replaceFunc(String input, Pattern pattern, Function<Matcher, String> func) {
        StringBuffer b = new StringBuffer();
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            m.appendReplacement(b, Matcher.quoteReplacement(func.apply(m)));
        }
        m.appendTail(b);
        return b.toString();
    }

    public static float checkSimilarity(String a, String b, float min, int method) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        float sim = method == 2 ? StringUtil.getSimilarity2(a, b) : (StringUtil.getLengthSimilarity(a, b) >= min ? StringUtil.getSimilarity(a, b) : 0.0f);
        return sim >= min ? sim : 0.0f;
    }

    public static float getLengthSimilarity(String a, String b) {
        return (float)Math.min(a.length(), b.length()) / (float)Math.max(a.length(), b.length()) + 0.2f;
    }

    public static String prepareForSimilarityComparison(String input, char[] chars) {
        return StringUtil.removeWhitespaceAndMore(input, chars);
    }

    public static float getSimilarity(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        if (a.equals(b)) {
            return 1.0f;
        }
        if (a.length() < 2 || b.length() < 2) {
            return 0.0f;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(a.length());
        for (int i = 0; i < a.length() - 1; ++i) {
            Integer part = a.charAt(i) + (a.charAt(i + 1) << 16);
            m.put(part, m.getOrDefault(part, 0) + 1);
        }
        int count = 0;
        for (int i = 0; i < b.length() - 1; ++i) {
            Integer part = b.charAt(i) + (b.charAt(i + 1) << 16);
            int c = m.getOrDefault(part, 0);
            if (c <= 0) continue;
            ++count;
            m.put(part, c - 1);
        }
        return 2.0f * (float)count / (float)(a.length() + b.length() - 2);
    }

    public static float getSimilarity2(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        if (a.equals(b)) {
            return 1.0f;
        }
        if (a.length() < 2 || b.length() < 2) {
            return 0.0f;
        }
        HashSet<Integer> setA = new HashSet<Integer>();
        HashSet<Integer> setB = new HashSet<Integer>();
        for (int i = 0; i < a.length() - 1; ++i) {
            Integer part = a.charAt(i) + (a.charAt(i + 1) << 16);
            setA.add(part);
        }
        int count = 0;
        for (int i = 0; i < b.length() - 1; ++i) {
            Integer part = b.charAt(i) + (b.charAt(i + 1) << 16);
            if (!setB.add(part) || !setA.contains(part)) continue;
            ++count;
        }
        return 2.0f * (float)count / (float)(setA.size() + setB.size());
    }

    public static String plural(String input, int num) {
        if (num == 0 || num > 1) {
            return input + "s";
        }
        return input;
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length());
        }
        return string;
    }

    public static String codePointSubstring(String input, int start, int end) {
        int correctedStart = input.offsetByCodePoints(0, start);
        int correctedEnd = input.offsetByCodePoints(correctedStart, end - start);
        return input.substring(correctedStart, correctedEnd);
    }

    public static final void main(String[] args) {
        System.out.println(StringUtil.shortenTo("abcdefghi", 8, 5));
        System.out.println(StringUtil.concats("a", null, "b", null));
    }

    private static class NullComparator
    implements Comparator<String> {
        private NullComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

