/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.Editor;
import chatty.util.StringUtil;
import chatty.util.colors.ColorCorrection;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.commands.CommandSyntaxHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class SyntaxHighlighter {
    protected final List<Item> items = new ArrayList<Item>();
    private boolean isEnabled = true;
    private int tempStart = -1;
    private Type tempType;

    public abstract void update(String var1);

    public List<Item> getItems(String input) {
        if (this.isEnabled) {
            this.update(input);
            return this.items;
        }
        return new ArrayList<Item>();
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void clear() {
        this.items.clear();
    }

    public void add(int start, int end) {
        this.add(start, end, Type.REGULAR);
    }

    public void add(int start, int end, Type type) {
        this.items.add(new Item(start, end, type));
    }

    public void start(int start, Type type) {
        this.tempStart = start;
        this.tempType = type;
    }

    public void end(int end) {
        if (this.tempStart != -1) {
            this.items.add(new Item(this.tempStart, end, this.tempType));
            this.tempStart = -1;
            this.tempType = null;
        }
    }

    public static Runnable install(JTextPane pane, SyntaxHighlighter hl) {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        pane.setDocument(doc);
        SimpleAttributeSet defaultAttr = new SimpleAttributeSet();
        final Runnable updateStyles = () -> {
            try {
                doc.setCharacterAttributes(0, doc.getLength(), defaultAttr, true);
                for (Item item : hl.getItems(pane.getText())) {
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    boolean dark = ColorCorrection.isDarkColor(pane.getBackground());
                    Color fg = ColorCorrection.correctReadability(Color.BLUE, pane.getBackground());
                    StyleConstants.setBackground(attr, ColorCorrectionNew.offset(pane.getBackground(), 0.89f));
                    switch (item.type) {
                        case REGULAR: {
                            StyleConstants.setBold(attr, true);
                            StyleConstants.setForeground(attr, fg);
                            break;
                        }
                        case REGULAR2: {
                            StyleConstants.setBold(attr, true);
                            StyleConstants.setForeground(attr, fg);
                            break;
                        }
                        case ESCAPE: {
                            StyleConstants.setBold(attr, true);
                            StyleConstants.setForeground(attr, ColorCorrectionNew.offset(pane.getForeground(), 0.7f));
                            break;
                        }
                        case IDENTIFIER: {
                            StyleConstants.setForeground(attr, fg);
                            StyleConstants.setItalic(attr, true);
                            break;
                        }
                        case ERROR: {
                            StyleConstants.setForeground(attr, dark ? Color.ORANGE : Color.RED);
                            StyleConstants.setUnderline(attr, true);
                        }
                    }
                    doc.setCharacterAttributes(item.start, item.end - item.start, attr, false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        };
        doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                fb.insertString(offset, StringUtil.removeLinebreakCharacters(string), attr);
                updateStyles.run();
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                fb.remove(offset, length);
                updateStyles.run();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                fb.replace(offset, length, StringUtil.removeLinebreakCharacters(text), attrs);
                updateStyles.run();
            }
        });
        updateStyles.run();
        return updateStyles;
    }

    private static Highlighter.HighlightPainter createPainter(Color color) {
        return new DefaultHighlighter.DefaultHighlightPainter(color);
    }

    public static Runnable install(JTextComponent comp, SyntaxHighlighter hl) {
        MyHighlightPainter highlightPainterError = new MyHighlightPainter();
        ((DefaultHighlighter)comp.getHighlighter()).setDrawsLayeredHighlights(false);
        Runnable update = () -> {
            comp.getHighlighter().removeAllHighlights();
            for (Item entry : hl.getItems(comp.getText())) {
                Highlighter.HighlightPainter painter;
                boolean dark = ColorCorrection.isDarkColor(comp.getBackground());
                switch (entry.type) {
                    case ESCAPE: {
                        painter = SyntaxHighlighter.createPainter(dark ? new Color(95, 95, 255) : new Color(160, 160, 255));
                        break;
                    }
                    case ERROR: {
                        painter = highlightPainterError;
                        break;
                    }
                    case REGULAR2: {
                        painter = SyntaxHighlighter.createPainter(dark ? new Color(0, 125, 0) : new Color(50, 255, 50));
                        break;
                    }
                    default: {
                        painter = SyntaxHighlighter.createPainter(dark ? new Color(20, 138, 20) : new Color(125, 255, 125));
                    }
                }
                try {
                    comp.getHighlighter().addHighlight(entry.start, entry.end, painter);
                }
                catch (BadLocationException badLocationException) {}
            }
            comp.repaint();
        };
        GuiUtil.addChangeListener(comp.getDocument(), e -> update.run());
        return update;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Editor editor = new Editor(frame);
        editor.setSyntaxHighlighter(new CommandSyntaxHighlighter());
        frame.pack();
        frame.setVisible(true);
        editor.showDialog("abc", "", "abc");
    }

    public static enum Type {
        REGULAR,
        REGULAR2,
        ESCAPE,
        ERROR,
        IDENTIFIER;

    }

    public static class Item {
        public final int start;
        public final int end;
        public final Type type;

        public Item(int start, int end, Type type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        public String toString() {
            return String.format("%d-%d[%s]", new Object[]{this.start, this.end, this.type});
        }
    }

    public static class MyHighlightPainter
    implements Highlighter.HighlightPainter {
        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                g.setColor(ColorCorrection.isDarkColor(c.getBackground()) ? Color.ORANGE : Color.RED);
                Rectangle r = p0.union(p1);
                g.fillRect(r.x, r.y + r.height - 3, r.width, 2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

