/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class TimedCounter {
    private final LinkedList<Long> data = new LinkedList();
    private long interval;

    public TimedCounter(long interval) {
        this.interval = TimeUnit.MILLISECONDS.toNanos(interval);
    }

    public int getCount() {
        return this.getCount(true);
    }

    public synchronized int getCount(boolean remove) {
        if (remove) {
            this.clearUp();
        }
        return this.data.size();
    }

    public synchronized void increase() {
        this.clearUp();
        this.data.addFirst(System.nanoTime());
    }

    private void clearUp() {
        while (!this.data.isEmpty() && System.nanoTime() - this.data.getLast() > this.interval) {
            this.data.removeLast();
        }
    }

    public synchronized void setInterval(long interval) {
        this.interval = TimeUnit.MILLISECONDS.toNanos(interval);
        this.clearUp();
    }
}

