/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeoutPatternMatcher {
    public static Matcher create(String regex, String text, long timeoutMillis) {
        Pattern pattern = Pattern.compile(regex);
        return TimeoutPatternMatcher.create(pattern, text, timeoutMillis);
    }

    public static Matcher create(Pattern pattern, String text, long timeoutMillis) {
        TimeoutCharSequence charSequence = new TimeoutCharSequence(text, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis));
        return pattern.matcher(charSequence);
    }

    private static class TimeoutCharSequence
    implements CharSequence {
        private final CharSequence inner;
        private final long timeoutTime;
        private int count;

        public TimeoutCharSequence(CharSequence inner, long timeoutTime) {
            this.inner = inner;
            this.timeoutTime = timeoutTime;
        }

        @Override
        public char charAt(int index) {
            ++this.count;
            if (this.count % 100 == 0 && this.timeoutTime - System.nanoTime() < 0L) {
                throw new MatcherTimeoutException();
            }
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeoutCharSequence(this.inner.subSequence(start, end), this.timeoutTime);
        }

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }

    public static class MatcherTimeoutException
    extends RuntimeException {
        public MatcherTimeoutException() {
            super("Regex took too long to match");
        }
    }
}

