/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Room;
import chatty.util.DateTime;
import chatty.util.StringUtil;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimerCommand {
    public static final String TIMER_PARAMETERS_KEY = "timercommand";
    public static final String TIMER_PARAMETERS_KEY_CHANGED_CHANNEL = "timercommand-changed-channel";
    private static final String SETTING_NAME = "timers";
    private final List<TimerEntry> entries = new ArrayList<TimerEntry>();
    private final Timer timer = new Timer("TimerCommand");
    private final TimerAction action;
    private final Map<String, Integer> idCounter = new HashMap<String, Integer>();
    private static final Pattern PARSER = Pattern.compile("(?:-(?<options>[a-z]+) )?(?::(?<id>[^ ]+) )?(?<command>stop|list|(?<simple>[0-9mshd:]+) |\\[(?<datetime>[0-9: -]+)\\] )(?<task>.*)");
    private static final String USAGE = "Usage: /timer [-options] [:id] <duration|time|'list'|'stop'> <timed command>";
    private static final DateTimeFormatter LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NORMAL).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();

    public TimerCommand(Settings settings, TimerAction action) {
        this.action = action;
        settings.addSettingsListener(s -> this.saveSettings(s));
    }

    public TimerResult command(String input, Room room, Parameters parameters) {
        if (input == null) {
            return new TimerResult(USAGE, null);
        }
        if (parameters.hasKey(TIMER_PARAMETERS_KEY)) {
            return new TimerResult("Can't call /timer from a timed command", null);
        }
        Matcher m = PARSER.matcher(input);
        if (m.matches()) {
            String id = m.group("id");
            String command = m.group("command");
            String task = m.group("task");
            Set<Option> options = TimerCommand.getOptions(m.group("options"));
            if (command.equals("list")) {
                if (id == null && !StringUtil.isNullOrEmpty(task.trim())) {
                    id = task.trim();
                }
                return new TimerResult(this.makeList(id, !options.contains((Object)Option.ADDED_ORDER)), null);
            }
            if (command.equals("stop")) {
                List<TimerEntry> filtered;
                if (id == null) {
                    if (!StringUtil.isNullOrEmpty(task.trim())) {
                        id = task.trim();
                    } else {
                        return new TimerResult("Timer id needs to be specified: /timer stop <id>", null);
                    }
                }
                if (!(filtered = this.getEntriesById(id)).isEmpty()) {
                    for (TimerEntry entry2 : filtered) {
                        this.stopTimer(entry2.id);
                    }
                    return new TimerResult(String.format("Timer stopped: %s", StringUtil.join(filtered, ", ", entry -> ((TimerEntry)entry).id)), null);
                }
                return new TimerResult(String.format("No matching timer found for '%s'", id), null);
            }
            if (StringUtil.isNullOrEmpty(task)) {
                return new TimerResult(USAGE, null);
            }
            String simpleTarget = m.group("simple");
            long targetTime = simpleTarget != null ? (simpleTarget.contains(":") ? TimerCommand.parseDatetime(simpleTarget) : System.currentTimeMillis() + DateTime.parseDuration(simpleTarget)) : TimerCommand.parseDatetime(m.group("datetime"));
            if (TimerCommand.isTargetInFuture(targetTime)) {
                TimerEntry entry3;
                if (this.getEntryById(id = this.makeId(id)) != null) {
                    if (options.contains((Object)Option.OVERWRITE)) {
                        this.stopTimer(id);
                    } else {
                        return new TimerResult("Timer with id " + id + " already exists", null);
                    }
                }
                if ((entry3 = this.addEntry(id, targetTime, task, room.getChannel(), options)) == null) {
                    return new TimerResult("Invalid time, no timer added", null);
                }
                if (entry3.options.contains((Object)Option.SILENT)) {
                    this.action.log("Silenced: " + entry3);
                    return new TimerResult(null, entry3);
                }
                return new TimerResult(entry3.toString(), entry3);
            }
            return new TimerResult("Invalid time, no timer added", null);
        }
        return new TimerResult(USAGE, null);
    }

    private synchronized String makeId(String id) {
        String numKey = null;
        if (StringUtil.isNullOrEmpty(id)) {
            numKey = "";
        } else if (id.endsWith("*")) {
            numKey = id.substring(0, id.length() - 1);
        }
        if (numKey != null) {
            int count = this.idCounter.getOrDefault(numKey, 0);
            while (this.getEntryById(id = numKey + ++count) != null) {
            }
            this.idCounter.put(numKey, count);
        }
        return id;
    }

    public synchronized TimerEntry addEntry(String id, long targetTime, final String command, final String channel, final Set<Option> options) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Parameters parameters = Parameters.create("");
                parameters.put(TimerCommand.TIMER_PARAMETERS_KEY, "true");
                TimerCommand.this.action.performAction(command, channel, parameters, options);
                TimerCommand.this.taskFinished(this);
            }
        };
        if (!TimerCommand.isTargetInFuture(targetTime)) {
            task.run();
            return null;
        }
        TimerEntry entry = new TimerEntry(id, targetTime, command, channel, options, task);
        this.entries.add(entry);
        this.timer.schedule(task, new Date(targetTime));
        return entry;
    }

    private synchronized boolean stopTimer(String id) {
        TimerEntry entry = this.getEntryById(id);
        if (entry != null) {
            entry.task.cancel();
            this.entries.remove(entry);
            return true;
        }
        return false;
    }

    private synchronized void taskFinished(TimerTask task) {
        Iterator<TimerEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            if (it.next().task != task) continue;
            it.remove();
        }
    }

    public synchronized int getNumTimers() {
        return this.entries.size();
    }

    private synchronized TimerEntry getEntryById(String id) {
        if (id == null) {
            return null;
        }
        for (TimerEntry entry : this.entries) {
            if (!entry.id.equals(id)) continue;
            return entry;
        }
        return null;
    }

    private synchronized List<TimerEntry> getEntriesById(String id) {
        ArrayList<TimerEntry> filtered = new ArrayList<TimerEntry>();
        for (TimerEntry entry : this.entries) {
            if (id != null && !entry.matchesId(id)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private synchronized String makeList(String id, boolean timeOrder) {
        if (this.entries.isEmpty()) {
            return "No active timers";
        }
        StringBuilder b = new StringBuilder();
        List<TimerEntry> filtered = this.getEntriesById(id);
        if (timeOrder) {
            filtered.sort((o1, o2) -> Long.compare(o1.targetTime, o2.targetTime));
        }
        if (id != null && !id.isEmpty()) {
            b.append(String.format("Currently %d active timers matching '%s' (out of %d):", filtered.size(), id, this.entries.size()));
        } else {
            b.append(String.format("Currently %d active timers:", this.entries.size()));
        }
        b.append("\n");
        for (TimerEntry entry : filtered) {
            b.append(entry.toString()).append("\n");
        }
        return b.toString();
    }

    private void saveSettings(Settings settings) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (TimerEntry entry : this.entries) {
            if (!entry.options.contains((Object)Option.KEEP_THROUGH_RESTART)) continue;
            data.add(entry.toList());
        }
        settings.putList(SETTING_NAME, data);
    }

    public String loadFromSettings(Settings settings) {
        List data = settings.getList(SETTING_NAME);
        if (data.isEmpty()) {
            return null;
        }
        int scheduled = 0;
        for (List entry : data) {
            Set<Option> options;
            String channel;
            String command;
            long targetTime;
            String id = (String)entry.get(0);
            TimerEntry addedTimer = this.addEntry(id, targetTime = ((Long)entry.get(1)).longValue(), command = (String)entry.get(2), channel = (String)entry.get(3), options = TimerCommand.getOptions((String)entry.get(4)));
            if (addedTimer != null) {
                ++scheduled;
                this.action.log("Restored timer: " + addedTimer);
                continue;
            }
            this.action.log("Executed restored timer: " + new TimerEntry(id, targetTime, command, channel, options, null));
        }
        return String.format("%d timer commands run, %d scheduled", data.size() - scheduled, scheduled);
    }

    private static Set<Option> getOptions(String input) {
        HashSet<Option> result = new HashSet<Option>();
        if (input != null) {
            for (Option option : Option.values()) {
                if (!input.contains(option.id)) continue;
                result.add(option);
            }
        }
        return result;
    }

    private static boolean isTargetInFuture(long targetTime) {
        return targetTime - System.currentTimeMillis() > 0L;
    }

    private static long parseDatetime(String input) {
        if (input == null) {
            return -1L;
        }
        try {
            LocalTime time;
            LocalDateTime datetime;
            String[] split = input.split(" ", 2);
            LocalDate date = null;
            String timeText = split[0];
            if (split.length == 2) {
                date = LocalDate.parse(split[0], DateTimeFormatter.ISO_LOCAL_DATE);
                timeText = split[1];
            }
            if ((datetime = (time = LocalTime.parse(timeText, LOCAL_TIME)).atDate(date != null ? date : LocalDate.now())).isBefore(LocalDateTime.now())) {
                datetime = datetime.plusDays(1L);
            }
            return datetime.toInstant(ZoneOffset.systemDefault().getRules().getOffset(datetime)).toEpochMilli();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static void main(String[] args) {
        LocalTime time;
        LocalDateTime datetime;
        String input = "2022-08-01 21:17:10";
        String[] split = input.split(" ", 2);
        LocalDate date = null;
        String timeText = split[0];
        if (split.length == 2) {
            date = LocalDate.parse(split[0], DateTimeFormatter.ISO_DATE);
            timeText = split[1];
        }
        if ((datetime = (time = LocalTime.parse(timeText, DateTimeFormatter.ISO_LOCAL_TIME)).atDate(date != null ? date : LocalDate.now())).isBefore(LocalDateTime.now())) {
            datetime = datetime.plusDays(1L);
        }
        System.out.println(datetime);
        System.out.println(datetime.toInstant(ZoneOffset.systemDefault().getRules().getOffset(datetime)));
        System.out.println(LocalDateTime.now().plusDays(1L).truncatedTo(ChronoUnit.DAYS));
    }

    public static interface TimerAction {
        public void performAction(String var1, String var2, Parameters var3, Set<Option> var4);

        public void log(String var1);
    }

    public static class TimerResult {
        public final String message;
        public final TimerEntry entry;

        public TimerResult(String message, TimerEntry entry) {
            this.entry = entry;
            this.message = message;
        }
    }

    public static class TimerEntry {
        private final TimerTask task;
        public final String command;
        public final String channel;
        public final String id;
        public final long targetTime;
        public final Set<Option> options;

        public TimerEntry(String id, long targetTime, String command, String channel, Set<Option> options, TimerTask task) {
            this.task = task;
            this.command = command;
            this.channel = channel;
            this.id = id;
            this.targetTime = targetTime;
            this.options = options;
        }

        public boolean matchesId(String id) {
            return this.id.equals(id) || id.endsWith("*") && this.id.startsWith(id.substring(0, id.length() - 1));
        }

        public String toString() {
            LocalDateTime datetime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.targetTime), ZoneId.systemDefault());
            LocalDateTime midnight = LocalDateTime.now().plusDays(1L).truncatedTo(ChronoUnit.DAYS);
            return String.format("Timer %s runs in %s (%s%s, %s) [%s]", this.id, DateTime.duration(this.targetTime - System.currentTimeMillis(), new DateTime.Formatting[0]), datetime.isBefore(midnight) ? DateTime.format(this.targetTime) : DateTime.formatFullDatetime(this.targetTime), this.options.isEmpty() ? "" : ", -" + StringUtil.join(this.options, "", o -> ((Option)((Object)((Object)o))).id), this.channel, StringUtil.shortenTo(this.command, 30));
        }

        public List<Object> toList() {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.id);
            result.add(this.targetTime);
            result.add(this.command);
            result.add(this.channel);
            result.add(StringUtil.join(this.options, "", o -> ((Option)((Object)((Object)o))).id));
            return result;
        }
    }

    public static enum Option {
        CHANNEL_LENIENT("a"),
        KEEP_THROUGH_RESTART("r"),
        SILENT("s"),
        OVERWRITE("o"),
        ADDED_ORDER("q");

        private final String id;

        private Option(String id) {
            this.id = id;
        }

        public static Option fromId(String id) {
            for (Option s : Option.values()) {
                if (!s.id.equals(id)) continue;
                return s;
            }
            return null;
        }
    }
}

