/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Room;
import chatty.util.DateTime;
import chatty.util.api.StreamInfo;
import chatty.util.api.TwitchApi;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Timestamp {
    private static final Logger LOGGER = Logger.getLogger(Timestamp.class.getName());
    private static final Pattern UPTIME = Pattern.compile("\\{(?:([^a-z]+),)?uptime(:[a-zA-Z0-9]+)?(?:,([^a-z]+))?\\}");
    public static final Pattern UPTIME_NO_CAPTURE = Pattern.compile("'\\{(?:[^a-z]+,)?uptime(?::[a-zA-Z0-9]+)?(?:,[^a-z]+)?\\}'");
    private static TwitchApi api;
    private final SimpleDateFormat format;
    private final boolean hasUptime;
    private final CustomCommand command;

    public Timestamp(String timestampInput, String timezone) {
        String customCommandInput = null;
        String[] split = timestampInput.split("###", 2);
        if (split.length == 2) {
            timestampInput = split[0];
            customCommandInput = split[1];
        }
        SimpleDateFormat parsedTimestamp = null;
        if (!timestampInput.equals("off")) {
            try {
                SimpleDateFormat sdf = DateTime.createSdfAmPm(timestampInput);
                if (!timezone.isEmpty() && !timezone.equalsIgnoreCase("local")) {
                    sdf.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                parsedTimestamp = sdf;
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning("Invalid timestamp: " + timestampInput);
            }
        }
        this.format = parsedTimestamp;
        this.hasUptime = UPTIME.matcher(timestampInput).find();
        CustomCommand parsedCommand = null;
        if (customCommandInput != null && (parsedCommand = CustomCommand.parse(customCommandInput)).hasError()) {
            LOGGER.warning("Timestamp command error: " + parsedCommand.getError());
            parsedCommand = null;
        }
        this.command = parsedCommand;
    }

    public static void setTwitchApi(TwitchApi api) {
        Timestamp.api = api;
    }

    public boolean isEnabled() {
        return this.format != null;
    }

    public String make(long time, Room room) {
        if (this.format != null && this.hasUptime && room != null && api != null) {
            StreamInfo info = api.getCachedStreamInfo(room.getStream());
            return this.make2(time, info);
        }
        return this.make2(time, null);
    }

    public String make2(long time, StreamInfo info) {
        String result;
        if (this.format == null) {
            return null;
        }
        String string = result = time > 0L ? DateTime.format(time, this.format) : DateTime.currentTime(this.format);
        if (this.hasUptime) {
            Matcher m = UPTIME.matcher(result);
            StringBuffer b = new StringBuffer();
            while (m.find()) {
                Timestamp.handleUptime(b, m, time, info);
            }
            m.appendTail(b);
            result = b.toString();
        }
        if (this.command != null) {
            Parameters param = Parameters.create(result);
            return this.command.replace(param);
        }
        return result;
    }

    private static void handleUptime(StringBuffer b, Matcher m, long time, StreamInfo info) {
        boolean uptimeAdded = false;
        if (info != null && (time > 0L || info.isValid() && info.getOnline())) {
            String prefix = m.group(1) != null ? m.group(1) : "";
            String suffix = m.group(3) != null ? m.group(3) : "";
            String options = m.group(2);
            int lower = 1;
            int upper = 3;
            int min = 1;
            ArrayList<DateTime.Formatting> options2 = new ArrayList<DateTime.Formatting>();
            boolean picnic = false;
            boolean picnicOptional = false;
            if (options != null) {
                if (options.contains("s")) {
                    lower = 0;
                    ++min;
                }
                if (options.contains("H")) {
                    ++min;
                }
                if (options.contains("c")) {
                    options2.add(DateTime.Formatting.CLOCK_STYLE);
                    options2.add(DateTime.Formatting.DOUBLE_DIGITS_EXCEPT_FIRST);
                    if (min < 2) {
                        ++min;
                    }
                }
                if (options.contains("00")) {
                    options2.remove((Object)DateTime.Formatting.DOUBLE_DIGITS_EXCEPT_FIRST);
                    options2.add(DateTime.Formatting.DOUBLE_DIGITS);
                } else if (options.contains("0")) {
                    options2.add(DateTime.Formatting.DOUBLE_DIGITS_EXCEPT_FIRST);
                }
                if (options.contains("t")) {
                    options2.add(DateTime.Formatting.NO_SPACES);
                }
                picnic = options.contains("p");
                if (options.contains("P")) {
                    picnic = true;
                    picnicOptional = true;
                }
            }
            long streamStarted = info.getHistoryStreamStart(time, picnic);
            if (picnicOptional && info.getHistoryStreamStart(time, false) == streamStarted) {
                streamStarted = -1L;
            }
            if (streamStarted != -1L) {
                long duration = Timestamp.getDuration(time, streamStarted);
                String uptime = DateTime.duration(duration, upper, 0, lower, min, options2);
                m.appendReplacement(b, prefix + uptime + suffix);
                uptimeAdded = true;
            }
        }
        if (!uptimeAdded) {
            m.appendReplacement(b, "");
        }
    }

    private static long getDuration(long time, long started) {
        if (time > 0L) {
            return time - started;
        }
        return System.currentTimeMillis() - started;
    }
}

