/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.api.Emoticon;
import chatty.util.api.Emoticons;
import chatty.util.api.TwitchApi;
import java.util.Objects;
import java.util.logging.Logger;

public class TwitchEmotesApi {
    private static final Logger LOGGER = Logger.getLogger(TwitchEmotesApi.class.getName());
    public static final TwitchEmotesApi api = new TwitchEmotesApi();
    private TwitchApi twitchApi;
    private static final String[] MODIFIERS = new String[]{"_BW", "_HF", "_SG", "_SQ", "_TK"};

    public void setTwitchApi(TwitchApi api) {
        this.twitchApi = api;
    }

    public void requestByStream(String stream) {
        this.twitchApi.getEmotesByChannelId(stream, null, false);
    }

    public static boolean isModified(Emoticon emote) {
        if (emote.type == Emoticon.Type.TWITCH && emote.stringId != null) {
            for (String suffix : MODIFIERS) {
                if (!emote.stringId.endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getEmoteType(Emoticon emote) {
        String modified;
        String emoteset = emote.emoteset;
        String string = modified = TwitchEmotesApi.isModified(emote) ? " [modified]" : "";
        if (emote.hasGlobalEmoteset()) {
            return "Twitch Global" + modified;
        }
        if (Emoticons.isTurboEmoteset(emoteset)) {
            return "Turbo Emoticon" + modified;
        }
        if (emote.getEmotesetInfo() != null) {
            if (emote.getEmotesetInfo().startsWith("Tier")) {
                return emote.getEmotesetInfo() + " Subemote";
            }
            return emote.getEmotesetInfo();
        }
        return "Unknown Emote" + modified;
    }

    public static class EmotesetInfo {
        public final String emoteset_id;
        public final String product;
        public final String stream_name;
        public final String stream_id;

        public EmotesetInfo(String emoteset_id, String stream_name, String stream_id, String product) {
            this.emoteset_id = emoteset_id;
            this.product = product;
            this.stream_name = stream_name;
            this.stream_id = stream_id;
        }

        public String toString() {
            return String.format("%s(%s,%s,%s)", this.emoteset_id, this.stream_name, this.stream_id, this.product);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmotesetInfo other = (EmotesetInfo)obj;
            return Objects.equals(this.emoteset_id, other.emoteset_id);
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.emoteset_id);
            return hash;
        }
    }
}

