/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class UniqueLimitedRingBuffer<T> {
    private final LinkedList<T> list = new LinkedList();
    private final Set<T> set = new HashSet<T>();
    private final int capacity;

    public UniqueLimitedRingBuffer(int capacity) {
        this.capacity = capacity;
    }

    public void append(T e) {
        if (this.set.add(e)) {
            this.list.addLast(e);
        } else {
            this.list.remove(e);
            this.list.addLast(e);
        }
        if (this.list.size() > this.capacity) {
            this.list.removeFirst();
        }
    }

    public T pollLast() {
        T removed = this.list.pollLast();
        this.set.remove(removed);
        return removed;
    }

    public void remove(T o) {
        this.list.remove(o);
        this.set.remove(o);
    }
}

