/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class UrlRequest {
    private static final Logger LOGGER = Logger.getLogger(UrlRequest.class.getName());
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String VERSION = "Chatty 0.28";
    private String url;
    private String label = "";
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private Map<String, String> properties;

    public UrlRequest() {
    }

    public UrlRequest(String url) {
        this.url = url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final void setLabel(String label) {
        this.label = "[" + label + "]";
    }

    public final void setTimeouts(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public final void setRequestProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public void async(ResultListener listener) {
        new Thread(() -> {
            FullResult result = new FullResult();
            this.performRequest(result);
            if (Debugging.isEnabled("requestresponse") && result.result != null) {
                LOGGER.info(result.result);
            }
            listener.result(result.getResult(), result.getResponseCode());
        }).start();
    }

    public void asyncLines(ResultLinesListener listener) {
        new Thread(() -> {
            LinesResult result = new LinesResult();
            this.performRequest(result);
            listener.result(result.getResult(), result.getResponseCode());
        }).start();
    }

    public FullResult sync() {
        FullResult result = new FullResult();
        this.performRequest(result);
        return result;
    }

    public LinesResult syncLines() {
        LinesResult result = new LinesResult();
        this.performRequest(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest(Result result) {
        LOGGER.info("<" + this.label + " " + this.url + (this.properties != null ? " " + this.properties.keySet() : ""));
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            if (this.properties != null) {
                for (Map.Entry<String, String> header : this.properties.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            connection.setRequestProperty("User-Agent", VERSION);
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            String encoding = connection.getContentEncoding();
            InputStream input = connection.getInputStream();
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            int responseCode = connection.getResponseCode();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, CHARSET));){
                result.fill(reader, responseCode);
            }
            LOGGER.info(String.format(">%s (%s, %,d%s): %s", this.label, responseCode, result.getLength(), encoding != null ? ", " + encoding : "", this.url));
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                result.responseCode = 404;
            }
            LOGGER.warning(String.format("!%s (%s): %s", this.label, ex, this.url));
            result.error = ex.getClass().getSimpleName() + " (" + ex.getLocalizedMessage() + ")";
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void main(String[] args) {
        UrlRequest request = new UrlRequest("http://bit.ly/1II1E2o");
        request.setLabel("Test");
        FullResult result = request.sync();
    }

    public static interface ResultListener {
        public void result(String var1, int var2);
    }

    public static interface ResultLinesListener {
        public void result(List<String> var1, int var2);
    }

    public static class FullResult
    extends Result {
        private String result;

        @Override
        public void fill(BufferedReader reader, int responseCode) throws IOException {
            String line;
            this.responseCode = responseCode;
            StringBuilder b = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                b.append(line).append("\n");
                this.length += line.length() + 1;
            }
            this.result = b.toString();
        }

        public String getResult() {
            return this.result;
        }
    }

    public static abstract class Result {
        protected int responseCode;
        protected int length;
        protected String error;

        public abstract void fill(BufferedReader var1, int var2) throws IOException;

        public int getResponseCode() {
            return this.responseCode;
        }

        public int getLength() {
            return this.length;
        }

        public String getError() {
            return this.error;
        }
    }

    public static class LinesResult
    extends Result {
        private List<String> result;

        @Override
        public void fill(BufferedReader reader, int responseCode) throws IOException {
            String line;
            this.responseCode = responseCode;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
                this.length += line.length();
            }
            this.result = lines;
        }

        public List<String> getResult() {
            return this.result;
        }
    }
}

