/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class Webserver
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Webserver.class.getName());
    public static final int ERROR_COULD_NOT_LISTEN_TO_PORT = 0;
    private static final int SO_TIMEOUT = 10000;
    private static int port = 61324;
    private volatile boolean running = true;
    private volatile ServerSocket serverSocket = null;
    private final WebserverListener listener;
    private int connectionCount = 0;
    private final List<WebserverConnection> connections = Collections.synchronizedList(new ArrayList());

    public static void main(String[] args) {
        Webserver s = new Webserver(new WebserverListener(){

            @Override
            public void webserverStarted() {
                System.out.println("Display a message that it's ready or whatever");
            }

            @Override
            public void webserverStopped() {
                System.out.println("Do whatever you want to do when the server was stopped");
            }

            @Override
            public void webserverError(String error) {
                System.out.println("Display a message that an error occured");
            }

            @Override
            public void webserverTokenReceived(String token) {
                System.out.println("Save token and stuff");
            }
        });
        new Thread(s).start();
    }

    public Webserver(WebserverListener listener) {
        this.listener = listener;
    }

    public void stop() {
        this.running = false;
        this.close();
    }

    private void debug(String message) {
        message = "Webserver: " + message;
        LOGGER.info(message);
    }

    @Override
    public void run() {
        this.debug("Trying to start webserver at port " + port);
        try {
            this.serverSocket = new ServerSocket(port, 0, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException ex) {
            this.debug("Could not listen to port " + port + " (" + ex.getLocalizedMessage() + ")");
            if (this.listener != null) {
                this.listener.webserverError("Could not listen to port " + port);
            }
            this.stop();
            return;
        }
        if (this.listener != null) {
            this.listener.webserverStarted();
        }
        while (this.running) {
            this.debug("Waiting for connections on " + this.serverSocket.toString());
            Socket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (SocketException ex) {
                this.debug("Accept interrupted: " + ex);
                break;
            }
            catch (IOException ex) {
                this.debug("ServerSocket accept failed: " + ex);
                break;
            }
            catch (NullPointerException ex) {
                break;
            }
            this.newConnection(clientSocket);
        }
        this.close();
        if (this.listener != null) {
            this.listener.webserverStopped();
        }
        this.debug("Stopped");
    }

    private void close() {
        this.closeConnections();
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException ex) {
            this.debug("Error closing ServerSocket: " + ex.getLocalizedMessage());
        }
    }

    private void newConnection(Socket clientSocket) {
        WebserverConnection connection = new WebserverConnection(clientSocket, this.connectionCount++);
        new Thread(connection).start();
        this.connections.add(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        List<WebserverConnection> list = this.connections;
        synchronized (list) {
            for (WebserverConnection c : this.connections) {
                c.close();
            }
            this.connections.clear();
        }
    }

    public static interface WebserverListener {
        public void webserverStarted();

        public void webserverStopped();

        public void webserverError(String var1);

        public void webserverTokenReceived(String var1);
    }

    class WebserverConnection
    implements Runnable {
        private final int connectionNumber;
        private final Socket connection;

        WebserverConnection(Socket connection, int connectionNumber) {
            this.connectionNumber = connectionNumber;
            this.connection = connection;
        }

        private void debugConnection(String message) {
            Webserver.this.debug("[" + this.connectionNumber + "] " + message);
        }

        @Override
        public void run() {
            this.debugConnection("Handling connection");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));){
                this.connection.setSoTimeout(10000);
                String request = input.readLine();
                if (request != null) {
                    this.respond(request);
                }
            }
            catch (IOException ex) {
                this.debugConnection("Error reading: " + ex);
            }
            this.debugConnection("Closed");
        }

        private void respond(String request) {
            this.debugConnection("Making response for " + this.removeToken(request));
            try (OutputStream output = this.connection.getOutputStream();){
                String response = "";
                if (StringUtil.toLowerCase(request).startsWith("get /token/")) {
                    String token = this.getToken(request);
                    if (token.isEmpty()) {
                        response = this.makeResponse("token_redirect.html");
                        this.debugConnection("Token redirect");
                    } else {
                        response = this.makeResponse("token_received.html");
                        this.debugConnection("Token received");
                        if (Webserver.this.listener != null) {
                            Webserver.this.listener.webserverTokenReceived(token);
                        }
                    }
                } else {
                    response = StringUtil.toLowerCase(request).startsWith("get /tokenreceived/") ? this.makeResponse("token_received_no_redirect.html") : this.makeResponse(null);
                }
                output.write(response.getBytes("UTF-8"));
            }
            catch (IOException ex) {
                this.debugConnection("Error responding: " + ex.getLocalizedMessage());
            }
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (IOException ex) {
                this.debugConnection("Failed closing connection: " + ex);
            }
        }

        private String removeToken(String request) {
            if (this.getToken(request).isEmpty()) {
                return request;
            }
            return request.replace(this.getToken(request), "<token>");
        }

        private String getToken(String request) {
            int start = request.indexOf("/token/");
            if (start == -1) {
                return "";
            }
            int end = request.indexOf(" ", start += "/token/".length());
            int end2 = request.indexOf("/", start);
            if (end2 != -1 && end2 < end) {
                end = end2;
            }
            if (end == -1) {
                return "";
            }
            return request.substring(start, end).trim();
        }

        private String makeResponse(String fileName) {
            if (fileName == null) {
                return this.makeHeader(false) + "Nothing here..";
            }
            String content = "";
            try {
                String line;
                InputStream input = this.getClass().getResourceAsStream(fileName);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
                StringBuilder buffer = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                content = buffer.toString();
            }
            catch (Exception ex) {
                Webserver.this.debug(ex.toString());
                content = "<html><body>An error occured (couldn't read file)</body></html>";
            }
            return this.makeHeader(true) + content;
        }

        private String makeHeader(boolean ok) {
            String header = "";
            header = ok ? header + "HTTP/1.0 200 OK\n" : header + "HTTP/1.0 403 Forbidden\n";
            header = header + "Server: ChattyWebserver\n";
            header = header + "Content-Type: text/html; charset=UTF-8\n\n";
            return header;
        }
    }
}

