/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.ArrayList;
import java.util.List;

public class WrapHistory<E> {
    private final List<E> data = new ArrayList();
    private final int size;
    private int pos = -1;
    private int start = -1;
    private int end;

    public WrapHistory(int size) {
        this.size = size;
    }

    public void addIfNew(E item) {
        if (!item.equals(this.current())) {
            this.add(item);
        }
    }

    public void add(E item) {
        this.pos = (this.pos + 1) % this.size;
        if (this.data.size() <= this.pos) {
            this.data.add(item);
        } else {
            this.data.set(this.pos, item);
        }
        if (this.start == -1) {
            this.start = 0;
        } else if (this.pos == this.start) {
            this.start = (this.start + 1) % this.size;
        }
        this.end = this.pos;
    }

    public E peekForward() {
        int nextPos = (this.pos + 1) % this.size;
        if (nextPos >= this.data.size() || this.pos == this.end) {
            return null;
        }
        return this.data.get(nextPos);
    }

    public E peekBackwards() {
        int prevPos = (this.pos + this.size - 1) % this.size;
        if (prevPos >= this.data.size() || this.pos == this.start) {
            return null;
        }
        return this.data.get(prevPos);
    }

    public E forward() {
        E nextItem = this.peekForward();
        if (nextItem == null) {
            return null;
        }
        this.pos = (this.pos + 1) % this.size;
        return nextItem;
    }

    public E backward() {
        E prevItem = this.peekBackwards();
        if (prevItem == null) {
            return null;
        }
        this.pos = (this.pos + this.size - 1) % this.size;
        return prevItem;
    }

    public E current() {
        if (this.pos < 0 || this.pos >= this.data.size()) {
            return null;
        }
        return this.data.get(this.pos);
    }

    public boolean hasNext() {
        return this.peekForward() != null;
    }

    public boolean hasPrevious() {
        return this.peekBackwards() != null;
    }

    public String debug() {
        return "Pos: " + this.pos + " First/Last: " + this.start + "/" + this.end + " Data: " + this.data;
    }

    public static void main(String[] args) {
        WrapHistory<String> h = new WrapHistory<String>(3);
        System.out.println("peekForward:" + (String)h.peekForward());
        System.out.println("peekBackwards:" + (String)h.peekBackwards());
        h.add("test1");
        System.out.println(h.debug());
        System.out.println("peekForward:" + (String)h.peekForward());
        System.out.println("peekBackwards:" + (String)h.peekBackwards());
        System.out.println(h.hasPrevious());
        h.add("test2");
        System.out.println(h.debug());
        System.out.println("peekForward:" + (String)h.peekForward());
        System.out.println("forward:" + (String)h.forward());
        System.out.println("peekBackwards:" + (String)h.peekBackwards());
        h.add("test3");
        System.out.println(h.debug());
        h.add("test4");
        System.out.println(h.debug());
        System.out.println("peekBackwards:" + (String)h.peekBackwards());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println("backwards:" + (String)h.backward());
        h.add("test5");
        System.out.println(h.debug());
        System.out.println("peekForward:" + (String)h.peekForward());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println(h.debug());
        System.out.println("peekForward:" + (String)h.peekForward());
        System.out.println("forward:" + (String)h.forward());
        System.out.println("forward:" + (String)h.forward());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println(h.debug());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println(h.debug());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println(h.debug());
        System.out.println("forward:" + (String)h.forward());
        System.out.println(h.debug());
        System.out.println("backwards:" + (String)h.backward());
        System.out.println(h.debug());
    }
}

