/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.gui.MainGui;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import java.util.HashMap;
import java.util.Map;

public class AutoModCommandHelper {
    private final MainGui gui;
    private final Map<String, String> pendingApprove = new HashMap<String, String>();
    private final Map<String, String> pendingDeny = new HashMap<String, String>();
    private final TwitchApi api;

    public AutoModCommandHelper(MainGui gui, TwitchApi api) {
        this.gui = gui;
        this.api = api;
    }

    public void approve(String channel, String msgId) {
        if (StringUtil.isNullOrEmpty(msgId)) {
            this.gui.printSystem("Invalid message id.");
            return;
        }
        this.pendingApprove.put(msgId, channel);
        this.api.autoModApprove(msgId);
    }

    public void deny(String channel, String msgId) {
        if (StringUtil.isNullOrEmpty(msgId)) {
            this.gui.printSystem("Invalid message id.");
            return;
        }
        this.pendingDeny.put(msgId, channel);
        this.api.autoModDeny(msgId);
    }

    public void requestResult(TwitchApi.AutoModAction action, String msgId, TwitchApi.AutoModActionResult result) {
        if (this.pendingApprove.containsKey(msgId)) {
            if (result != TwitchApi.AutoModActionResult.SUCCESS) {
                this.gui.printSystem("[AutoMod/Approve] Error: " + result.errorMessage);
            }
            this.pendingApprove.remove(msgId);
        }
        if (this.pendingDeny.containsKey(msgId)) {
            if (result != TwitchApi.AutoModActionResult.SUCCESS) {
                this.gui.printSystem("[AutoMod/Deny] Error: " + result.errorMessage);
            }
            this.pendingDeny.remove(msgId);
        }
    }
}

