/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.util.Debugging;
import chatty.util.JSONUtil;
import chatty.util.api.TwitchApi;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class BadgeManager {
    private static final Logger LOGGER = Logger.getLogger(BadgeManager.class.getName());
    private final TwitchApi api;
    private boolean globalBadgesRequested = false;
    private final Set<String> roomsRequested = Collections.synchronizedSet(new HashSet());

    public BadgeManager(TwitchApi api) {
        this.api = api;
    }

    public void requestGlobalBadges(boolean forceRefresh) {
        if (!this.globalBadgesRequested || forceRefresh) {
            this.globalBadgesRequested = true;
            this.api.requests.requestGlobalBadges();
        }
    }

    public void requestBadges(String channel, boolean forceRefresh) {
        String room = Helper.toStream(channel);
        if (!this.roomsRequested.contains(room) || forceRefresh) {
            this.roomsRequested.add(room);
            this.api.waitForUserId(r -> this.api.requests.requestRoomBadges(r.getId(room), room), room);
        }
    }

    public List<Usericon> handleGlobalBadgesResult(String json) {
        return BadgeManager.parseBadges(json, null);
    }

    public List<Usericon> handleRoomBadgesResult(String json, String room) {
        return BadgeManager.parseBadges(json, room);
    }

    private static List<Usericon> parseBadges(String json, String room) {
        ArrayList<Usericon> result = new ArrayList<Usericon>();
        if (json == null) {
            return result;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray badges = (JSONArray)root.get("data");
            if (badges != null) {
                for (Object entry : badges) {
                    JSONObject data = (JSONObject)entry;
                    String id = JSONUtil.getString(data, "set_id");
                    JSONArray versions = (JSONArray)data.get("versions");
                    if (versions == null) continue;
                    BadgeManager.parseBadgeVersions(result, versions, room, id);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing badges: " + ex);
        }
        return result;
    }

    private static void parseBadgeVersions(List<Usericon> result, JSONArray data, String room, String id) {
        for (Object entry : data) {
            Usericon icon;
            String title;
            JSONObject versionData = (JSONObject)entry;
            String version = JSONUtil.getString(versionData, "id");
            String url = JSONUtil.getString(versionData, "image_url_1x");
            String url2 = JSONUtil.getString(versionData, "image_url_2x");
            String clickUrl = JSONUtil.getString(versionData, "click_url", "");
            String description = "";
            switch (id) {
                case "subscriber": {
                    title = BadgeManager.makeSubscriberTitle(version);
                    break;
                }
                case "bits": {
                    title = BadgeManager.makeBitsTitle(version);
                    break;
                }
                case "sub-gifter": {
                    title = BadgeManager.makeSubGifterTitle(version);
                    break;
                }
                default: {
                    title = JSONUtil.getString(versionData, "title");
                    description = JSONUtil.getString(versionData, "description");
                }
            }
            if (Objects.equals(title, description)) {
                description = "";
            }
            if (id == null || version == null || url == null || (icon = UsericonFactory.createTwitchBadge(id, version, url, url2, room, title, description, clickUrl)) == null) continue;
            result.add(icon);
            Debugging.println("badgetitles", "%s/%s %s", id, version, title);
        }
    }

    public static String makeSubscriberTitle(String version) {
        String title = "Subscriber";
        String tier = "0";
        String months = version;
        if (version.length() == 4) {
            tier = version.substring(0, 1);
            months = version.substring(1);
        }
        try {
            int monthsNum = Integer.parseInt(months);
            int tierNum = Integer.parseInt(tier);
            if (tierNum > 1) {
                title = "Tier " + tierNum + " " + title;
            }
            if (monthsNum > 1) {
                title = monthsNum + "-Month " + title;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return title;
    }

    private static String makeBitsTitle(String version) {
        String title = "Bits";
        try {
            int amount = Integer.parseInt(version);
            if (amount > 1) {
                title = amount < 1000 ? amount + " Bits" : amount / 1000 + "k Bits";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return title;
    }

    private static String makeSubGifterTitle(String version) {
        String title = "Sub Gifter";
        try {
            int amount = Integer.parseInt(version);
            if (amount > 1) {
                title = amount + " Gift Subs";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return title;
    }
}

