/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.Requests;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class BlockedTermsManager {
    private static final Logger LOGGER = Logger.getLogger(BlockedTermsManager.class.getName());
    private final Map<String, BlockedTerms> cache = new HashMap<String, BlockedTerms>();
    private final Requests requests;
    private String currentLogin;
    private BlockedTerms currentTerms;
    private Consumer<BlockedTerms> currentListener;
    private int currentRequestCount;
    public static final int MAX_PARTIAL_REQUESTS = 10;
    public static final int MAX_RESULTS_PER_REQUEST = 100;
    public static final int MAX_RESULTS = 1000;

    public BlockedTermsManager(Requests requests) {
        this.requests = requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBlockedTerms(String streamId, String streamName, boolean refresh, Consumer<BlockedTerms> listener) {
        BlockedTerms cached = null;
        Map<String, BlockedTerms> map = this.cache;
        synchronized (map) {
            cached = this.cache.get(streamName);
        }
        if (refresh || cached == null) {
            map = this.cache;
            synchronized (map) {
                this.currentLogin = streamName;
                this.currentTerms = null;
                this.currentListener = listener;
                this.currentRequestCount = 1;
            }
            this.requests.getBlockedTerms(streamId, streamName, null);
        } else {
            listener.accept(cached);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultReceived(String streamId, String streamName, String json, int responseCode) {
        BlockedTerms result = this.getResult(streamId, streamName, json, responseCode);
        Consumer<BlockedTerms> listener = null;
        Map<String, BlockedTerms> map = this.cache;
        synchronized (map) {
            listener = this.currentListener;
        }
        if (listener != null && result != null) {
            listener.accept(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockedTerms getResult(String streamId, String streamName, String json, int responseCode) {
        Map<String, BlockedTerms> map = this.cache;
        synchronized (map) {
            if (this.currentLogin == null) return null;
            if (!this.currentLogin.equals(streamName)) {
                return null;
            }
            BlockedTerms parsed = BlockedTerms.parse(json, streamId, streamName);
            if (parsed != null) {
                boolean requestCountCheck;
                if (this.currentTerms != null) {
                    parsed = parsed.combine(this.currentTerms);
                }
                String cursor = Requests.getCursor(json);
                boolean bl = requestCountCheck = this.currentRequestCount < 10;
                if (cursor != null && requestCountCheck) {
                    this.currentTerms = parsed;
                    ++this.currentRequestCount;
                    this.requests.getBlockedTerms(streamId, streamName, cursor);
                    return null;
                }
                if (cursor != null && !requestCountCheck) {
                    LOGGER.warning("Blocked Terms request limit reached");
                }
                this.currentTerms = null;
                this.currentLogin = null;
                this.cache.put(streamName, parsed);
                return parsed;
            }
            String errorText = "Error requesting data";
            if (responseCode == 403) {
                errorText = "Access denied";
            }
            BlockedTerms errorTerms = new BlockedTerms(streamId, streamName, errorText);
            this.cache.put(streamName, errorTerms);
            return errorTerms;
        }
    }

    public static class BlockedTerms {
        public final String streamId;
        public final String streamName;
        public final List<BlockedTerm> data;
        public final long createdAt;
        public final String error;

        public BlockedTerms(String streamId, String streamName, List<BlockedTerm> data) {
            this.streamId = streamId;
            this.streamName = streamName;
            this.data = data;
            this.createdAt = System.currentTimeMillis();
            this.error = null;
        }

        public BlockedTerms(String streamId, String streamName, String error) {
            this.streamId = streamId;
            this.streamName = streamName;
            this.data = null;
            this.createdAt = System.currentTimeMillis();
            this.error = error;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public BlockedTerms combine(BlockedTerms other) {
            ArrayList<BlockedTerm> newData = new ArrayList<BlockedTerm>();
            newData.addAll(this.data);
            newData.addAll(other.data);
            return new BlockedTerms(this.streamId, this.streamName, newData);
        }

        public static BlockedTerms parse(String json, String streamId, String streamName) {
            if (json == null) {
                return null;
            }
            try {
                ArrayList<BlockedTerm> terms = new ArrayList<BlockedTerm>();
                JSONParser parser = new JSONParser();
                JSONObject root = (JSONObject)parser.parse(json);
                JSONArray data = (JSONArray)root.get("data");
                for (Object o : data) {
                    JSONObject entry;
                    BlockedTerm blockedTerm;
                    if (!(o instanceof JSONObject) || (blockedTerm = BlockedTerm.parse(entry = (JSONObject)o, streamName)) == null) continue;
                    terms.add(blockedTerm);
                }
                return new BlockedTerms(streamId, streamName, terms);
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing blocked terms: " + ex);
                return null;
            }
        }

        public String toString() {
            return String.valueOf(this.data);
        }
    }

    public static class BlockedTerm {
        public final String id;
        public final long createdAt;
        public final long updatedAt;
        public final long expiresAt;
        public final String text;
        public final String moderatorId;
        public final String streamId;
        public final String streamLogin;

        public BlockedTerm(String id, long createdAt, long updatedAt, long expiresAt, String text, String moderatorId, String streamId, String streamLogin) {
            this.id = id;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.expiresAt = expiresAt;
            this.text = text;
            this.moderatorId = moderatorId;
            this.streamId = streamId;
            this.streamLogin = streamLogin;
        }

        public static BlockedTerm parse(JSONObject data, String streamLogin) {
            String id = JSONUtil.getString(data, "id");
            long createdAt = JSONUtil.getDatetime(data, "created_at", -1L);
            long updatedAt = JSONUtil.getDatetime(data, "updated_at", -1L);
            long expiresAt = JSONUtil.getDatetime(data, "expires_at", -1L);
            String text = JSONUtil.getString(data, "text");
            String moderatorId = JSONUtil.getString(data, "moderator_id");
            String streamId = JSONUtil.getString(data, "broadcaster_id");
            if (!StringUtil.isNullOrEmpty(id, text, streamId)) {
                return new BlockedTerm(id, createdAt, updatedAt, expiresAt, text, moderatorId, streamId, streamLogin);
            }
            return null;
        }

        public String toString() {
            return this.text;
        }
    }
}

