/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.ImageCache;
import chatty.util.api.Emoticon;
import chatty.util.gif.AnimatedImageSource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;

public class CachedImage<T> {
    private static final Logger LOGGER = Logger.getLogger(CachedImage.class.getName());
    private static final int MAX_LOADING_ATTEMPTS = 3;
    private static final int LOADING_ATTEMPT_DELAY = 30000;
    private static final int CACHE_TIME = 1209600;
    public final float scaleFactor;
    public final int maxHeight;
    public final Object customKey;
    public final ImageType imageType;
    private final T object;
    private Set<CachedImageUser> users;
    private final CachedImageRequester requester;
    private ImageIcon icon;
    private String sourceUrl;
    private String loadedFrom;
    private boolean loading = false;
    private boolean loadingError = false;
    private boolean isLoaded = false;
    private volatile int loadingAttempts = 0;
    private long lastLoadingAttempt;
    private long lastUsed;
    private final String prefix;
    private final Function<ImageIcon, Image> modifyImageFunction;

    public CachedImage(T object, CachedImageRequester requester, String prefix, float scaleFactor, int maxHeight, Object customKey, Function<ImageIcon, Image> modifyImageFunction, ImageType imageType) {
        this.object = object;
        this.scaleFactor = scaleFactor;
        this.maxHeight = maxHeight;
        this.customKey = customKey;
        this.imageType = imageType;
        this.requester = requester;
        this.prefix = prefix;
        this.modifyImageFunction = modifyImageFunction;
    }

    public ImageIcon getImageIcon() {
        this.lastUsed = System.currentTimeMillis();
        if (this.icon == null) {
            this.icon = this.getDefaultIcon(false);
            if (this.requester.loadImage()) {
                this.loadImage();
            }
        } else if (this.loadingError && this.loadImage()) {
            LOGGER.warning("Trying to load " + this.object + " again (" + this.sourceUrl + ")");
        }
        return this.icon;
    }

    public long getLastUsedAge() {
        return System.currentTimeMillis() - this.lastUsed;
    }

    public T getObject() {
        return this.object;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getLoadedFromUrl() {
        return this.loadedFrom;
    }

    private boolean loadImage() {
        if (!this.loading && this.loadingAttempts < 3 && System.currentTimeMillis() - this.lastLoadingAttempt > 30000L) {
            this.loading = true;
            this.loadingError = false;
            ++this.loadingAttempts;
            this.lastLoadingAttempt = System.currentTimeMillis();
            new IconLoader(this).execute();
            return true;
        }
        return false;
    }

    private void setLoadingError() {
        this.setImageIcon(this.getDefaultIcon(true), false);
        this.loadingError = true;
    }

    public void setImageIcon(ImageIcon newIcon, boolean success) {
        if (this.icon == null) {
            this.setDefaultIcon();
        }
        boolean sizeChanged = this.icon.getIconWidth() != newIcon.getIconWidth() || this.icon.getIconHeight() != newIcon.getIconHeight();
        Image oldImage = this.icon.getImage();
        this.icon.setImage(newIcon.getImage());
        this.icon.setDescription(newIcon.getDescription());
        if (success) {
            this.setLoaded();
        }
        this.informUsers(oldImage, newIcon.getImage(), sizeChanged);
    }

    private void setSourceUrl(String url) {
        this.sourceUrl = url;
    }

    private void setLoadedFromUrl(String url) {
        this.loadedFrom = url;
    }

    public boolean isAnimated() {
        boolean emoteAnimated = this.object instanceof Emoticon ? ((Emoticon)this.object).isAnimated() : false;
        boolean imageLoadedAsGif = this.icon != null && this.icon.getDescription() != null && this.icon.getDescription().startsWith("GIF");
        boolean imageAnimatedSource = this.icon.getImage().getSource() instanceof AnimatedImageSource;
        return emoteAnimated || imageLoadedAsGif || imageAnimatedSource;
    }

    private void setLoadingDone() {
        this.loading = false;
    }

    private void setLoaded() {
        this.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void addUser(CachedImageUser user) {
        if (this.users == null) {
            this.users = Collections.newSetFromMap(new WeakHashMap());
        }
        this.users.add(user);
    }

    private void informUsers(Image oldImage, Image newImage, boolean sizeChanged) {
        for (CachedImageUser user : this.users) {
            user.iconLoaded(oldImage, newImage, sizeChanged);
        }
    }

    private ImageIcon getDefaultIcon(boolean error) {
        return this.modifyIconIfNecessary(new ImageIcon(this.getDefaultImage(error)));
    }

    private ImageIcon modifyIconIfNecessary(ImageIcon icon) {
        Image modified = this.requester.modifyImage(icon);
        if (modified != null) {
            icon.setImage(modified);
        }
        if (this.modifyImageFunction != null) {
            modified = this.modifyImageFunction.apply(icon);
        }
        if (modified != null) {
            icon.setImage(modified);
        }
        return icon;
    }

    public void setDefaultIcon() {
        this.icon = this.getDefaultIcon(false);
    }

    private Image getDefaultImage(boolean error) {
        Dimension d = ImageCache.ImageRequest.getScaledSize(this.requester.getBaseSize(), this.scaleFactor, this.maxHeight);
        int width = d.width;
        int height = d.height;
        BufferedImage res = new BufferedImage(width, height, 2);
        Graphics g = res.getGraphics();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.LIGHT_GRAY);
        if (error) {
            g.setColor(Color.red);
        }
        int sWidth = g.getFontMetrics().stringWidth("[x]");
        g.drawString("[x]", width / 2 - sWidth / 2, height / 2);
        g.dispose();
        return res;
    }

    public String toString() {
        return String.format("%s/%s/%s/%s|%s", new Object[]{Float.valueOf(this.scaleFactor), this.maxHeight, this.imageType, this.customKey, this.icon});
    }

    public String getSizeString() {
        Dimension baseSize = this.requester.getBaseSize();
        int scaledWidth = this.icon.getIconWidth();
        int scaledHeight = this.icon.getIconHeight();
        if ((scaledWidth != baseSize.width || scaledHeight != baseSize.height) && this.requester.forceBaseSize()) {
            return scaledWidth + "x" + scaledHeight + " (" + baseSize.width + "x" + baseSize.height + ")";
        }
        return scaledWidth + "x" + scaledHeight;
    }

    public static abstract class CachedImageRequester {
        public abstract String getImageUrl(int var1, ImageType var2);

        public abstract Dimension getBaseSize();

        public abstract boolean forceBaseSize();

        public void imageLoaded(ImageCache.ImageResult result) {
        }

        public boolean loadImage() {
            return true;
        }

        public Image modifyImage(ImageIcon image) {
            return null;
        }
    }

    public static enum ImageType {
        STATIC,
        ANIMATED_DARK,
        ANIMATED_LIGHT,
        TEMP;

    }

    private class IconLoader
    extends SwingWorker<ImageIcon, Object> {
        private final CachedImage<T> image;

        public IconLoader(CachedImage<T> image) {
            this.image = image;
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            Dimension defaultSize = CachedImage.this.requester.getBaseSize();
            boolean forceBaseSize = CachedImage.this.requester.forceBaseSize();
            ImageCache.ImageRequest request = new ImageCache.ImageRequest(scale -> CachedImage.this.requester.getImageUrl((int)scale, this.image.imageType), this.image.scaleFactor, this.image.maxHeight, defaultSize, forceBaseSize);
            if (!request.valid) {
                return null;
            }
            ImageCache.ImageResult result = ImageCache.getImage(request, CachedImage.this.prefix, 1209600);
            this.image.setSourceUrl(request.getRequestedURL().toString());
            this.image.setLoadedFromUrl(request.getLoadFromURL().toString());
            if (result == null || !result.isValidImage()) {
                return null;
            }
            if (result.icon.getIconWidth() > 250 || result.icon.getIconHeight() > 150) {
                return null;
            }
            CachedImage.this.requester.imageLoaded(result);
            return CachedImage.this.modifyIconIfNecessary(result.icon);
        }

        @Override
        protected void done() {
            try {
                ImageIcon loadedIcon = (ImageIcon)this.get();
                if (loadedIcon == null) {
                    this.image.setLoadingError();
                } else {
                    this.image.setImageIcon(loadedIcon, true);
                }
                this.image.setLoadingDone();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.warning("Unexpected error when loading emoticon: " + ex);
            }
        }
    }

    public static interface CachedImageUser {
        public void iconLoaded(Image var1, Image var2, boolean var3);
    }
}

