/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.HalfWeakSet2;
import chatty.util.api.CachedImage;
import java.awt.Image;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.ImageIcon;

public class CachedImageManager<T> {
    private HalfWeakSet2<CachedImage<T>> images;
    private final T object;
    private final CachedImage.CachedImageRequester requester;
    private final String prefix;

    public CachedImageManager(T object, CachedImage.CachedImageRequester requester, String prefix) {
        this.object = object;
        this.requester = requester;
        this.prefix = prefix;
    }

    public CachedImage<T> getIcon(float scaleFactor, int maxHeight, Object customKey, CachedImage.ImageType imageType, Function<ImageIcon, Image> modifyImage, CachedImage.CachedImageUser user) {
        if (this.images == null) {
            this.images = new HalfWeakSet2();
        }
        CachedImage<T> resultImage = null;
        for (CachedImage<T> image : this.images) {
            if (image == null || image.scaleFactor != scaleFactor || image.maxHeight != maxHeight || !Objects.equals(image.customKey, customKey) || image.imageType != imageType) continue;
            resultImage = image;
        }
        if (resultImage == null) {
            resultImage = new CachedImage<T>(this.object, this.requester, this.prefix, scaleFactor, maxHeight, customKey, modifyImage, imageType);
            this.images.add(resultImage);
        } else {
            this.images.markStrong(resultImage);
        }
        if (user != null) {
            resultImage.addUser(user);
        }
        return resultImage;
    }

    public void clearImages() {
        if (this.images != null) {
            this.images.clear();
        }
    }

    public int clearOldImages(int imageExpireMinutes) {
        if (this.images != null) {
            this.images.cleanUp();
            HashSet<CachedImage<T>> toRemove = new HashSet<CachedImage<T>>();
            Iterator<CachedImage<T>> it = this.images.strongIterator();
            while (it.hasNext()) {
                CachedImage<T> image = it.next();
                if (image.getLastUsedAge() <= (long)(imageExpireMinutes * 60 * 1000)) continue;
                toRemove.add(image);
            }
            for (CachedImage cachedImage : toRemove) {
                this.images.markWeak(cachedImage);
            }
            return toRemove.size();
        }
        return 0;
    }
}

