/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Logging;
import chatty.util.SimpleCache;
import java.util.logging.Logger;

public abstract class CachedManager {
    private static final Logger LOGGER = Logger.getLogger(CachedManager.class.getName());
    private final SimpleCache cache;
    private final String label;

    public CachedManager(String file, long expireTime, String label) {
        this.cache = new SimpleCache(label, file, expireTime);
        this.label = "[" + label + "] ";
    }

    public abstract boolean handleData(String var1);

    public boolean load() {
        return this.load(false);
    }

    public boolean load(boolean useFileEvenIfExpired) {
        boolean dataValid;
        String fromFile = this.loadFromFile(useFileEvenIfExpired);
        if (fromFile != null && (dataValid = this.handleData(fromFile))) {
            LOGGER.info(this.label + "Using data from file." + (useFileEvenIfExpired ? " (forced)" : ""));
            return true;
        }
        return false;
    }

    public void dataReceived(String data, boolean wasForcedUpdate) {
        boolean dataValid = this.handleData(data);
        if (dataValid) {
            this.saveToFile(data);
        } else if (!wasForcedUpdate) {
            this.load(true);
        } else {
            LOGGER.log(Logging.USERINFO, "Error requesting " + this.label + "from API.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(String json) {
        SimpleCache simpleCache = this.cache;
        synchronized (simpleCache) {
            this.cache.save(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadFromFile(boolean loadEvenIfExpired) {
        SimpleCache simpleCache = this.cache;
        synchronized (simpleCache) {
            return this.cache.load(loadEvenIfExpired);
        }
    }
}

