/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.DateTime;
import chatty.util.JSONUtil;
import chatty.util.api.ChannelInfo;
import chatty.util.api.ChannelStatus;
import chatty.util.api.TwitchApi;
import chatty.util.api.TwitchApiResultListener;
import java.util.HashMap;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ChannelInfoManager {
    private static final Logger LOGGER = Logger.getLogger(ChannelInfoManager.class.getName());
    private final TwitchApi api;
    private final TwitchApiResultListener listener;

    public ChannelInfoManager(TwitchApi api, TwitchApiResultListener listener) {
        this.api = api;
        this.listener = listener;
    }

    private void handleChannelInfoResultError(String stream, boolean put, int responseCode) {
        if (!put) {
            if (responseCode == 404) {
                this.listener.receivedChannelInfo(stream, null, TwitchApi.RequestResultCode.NOT_FOUND);
            } else {
                this.listener.receivedChannelInfo(stream, null, TwitchApi.RequestResultCode.FAILED);
            }
        } else if (responseCode == 404) {
            this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.NOT_FOUND, null);
        } else if (responseCode == 401 || responseCode == 403) {
            LOGGER.warning("Error setting channel info: Access denied");
            this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.ACCESS_DENIED, null);
            this.api.accessDenied();
        } else if (responseCode == 422) {
            LOGGER.warning("Error setting channel info: Probably invalid title");
            this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.INVALID_STREAM_STATUS, null);
        } else {
            LOGGER.warning("Error setting channel info: Unknown error (" + responseCode + ")");
            this.listener.putChannelInfoResult(TwitchApi.RequestResultCode.FAILED, null);
        }
    }

    private ChannelInfo parseChannelInfo(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            String name = (String)root.get("name");
            String id = (String)root.get("_id");
            String status = (String)root.get("status");
            String game = (String)root.get("game");
            String broadcaster_type = (String)root.get("broadcaster_type");
            String description = (String)root.get("description");
            int views = JSONUtil.getInteger(root, "views", -1);
            int followers = JSONUtil.getInteger(root, "followers", -1);
            long createdAt = -1L;
            long updatedAt = -1L;
            try {
                createdAt = DateTime.parseDatetime(JSONUtil.getString(root, "created_at"));
                updatedAt = DateTime.parseDatetime(JSONUtil.getString(root, "updated_at"));
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing ChannelInfo: " + ex);
            }
            return new ChannelInfo(name, id, createdAt, followers, views, updatedAt, broadcaster_type, description);
        }
        catch (ParseException ex) {
            LOGGER.warning("Error parsing ChannelInfo.");
            return null;
        }
        catch (ClassCastException ex) {
            LOGGER.warning("Error parsing ChannelInfo: Unexpected type");
            return null;
        }
    }

    protected String makeChannelInfoJson(ChannelStatus info) {
        HashMap<String, String> channel = new HashMap<String, String>();
        channel.put("status", info.title);
        channel.put("game", info.category.name);
        return JSONUtil.listMapToJSON("channel", channel);
    }
}

