/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.JSONUtil;
import chatty.util.StringUtil;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamLabels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ChannelStatus {
    private static final Logger LOGGER = Logger.getLogger(ChannelStatus.class.getName());
    public final String channelId;
    public final String channelLogin;
    public final String channelName;
    public final String title;
    public final StreamCategory category;
    public final List<StreamTag> tags;
    public final List<StreamLabels.StreamLabel> labels;

    public ChannelStatus(String channelId, String channelLogin, String channelName, String title, StreamCategory category, List<StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        this.channelId = channelId;
        this.channelLogin = channelLogin;
        this.channelName = channelName;
        this.title = title;
        this.category = category;
        this.tags = tags;
        this.labels = labels;
    }

    public static ChannelStatus createInvalid(String channelId, String channelLogin) {
        return new ChannelStatus(channelId, channelLogin, null, null, null, null, null);
    }

    public static ChannelStatus createPut(String channelLogin, String title, StreamCategory category, List<StreamTag> tags, List<StreamLabels.StreamLabel> labels) {
        if (category == null) {
            category = new StreamCategory("", "");
        }
        if (tags == null) {
            tags = new ArrayList<StreamTag>();
        }
        labels = labels == null ? new ArrayList<StreamLabels.StreamLabel>() : new ArrayList<StreamLabels.StreamLabel>(labels);
        labels.removeIf(label -> !label.isEditable());
        return new ChannelStatus(null, channelLogin, null, title, category, tags, labels);
    }

    public boolean isValid() {
        return StringUtil.isNullOrEmpty(this.channelId, this.channelLogin, this.title) && this.category != null && this.tags != null;
    }

    public boolean hasCategoryId() {
        return this.category != null && this.category.hasId();
    }

    public ChannelStatus changeCategory(StreamCategory category) {
        return new ChannelStatus(this.channelId, this.channelLogin, this.channelName, this.title, category, this.tags, this.labels);
    }

    public static List<ChannelStatus> parseJson(String json) {
        if (json == null) {
            return null;
        }
        try {
            ArrayList<ChannelStatus> result = new ArrayList<ChannelStatus>();
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray data = (JSONArray)root.get("data");
            for (Object item : data) {
                if (!(item instanceof JSONObject)) continue;
                JSONObject channel = (JSONObject)item;
                String channelId = JSONUtil.getString(channel, "broadcaster_id");
                String channelLogin = JSONUtil.getString(channel, "broadcaster_login");
                String channelName = JSONUtil.getString(channel, "broadcaster_name");
                String title = JSONUtil.getString(channel, "title");
                String gameId = JSONUtil.getString(channel, "game_id", "");
                if (gameId.equals("0")) {
                    gameId = "";
                }
                String gameName = JSONUtil.getString(channel, "game_name", "");
                List<String> tagsArray = JSONUtil.getStringList(channel, "tags");
                ArrayList<StreamTag> tags = new ArrayList<StreamTag>();
                for (String tag : tagsArray) {
                    tags.add(new StreamTag(tag));
                }
                List<String> labelsArray = JSONUtil.getStringList(channel, "content_classification_labels");
                ArrayList<StreamLabels.StreamLabel> labels = new ArrayList<StreamLabels.StreamLabel>();
                for (String id : labelsArray) {
                    labels.add(new StreamLabels.StreamLabel(id));
                }
                if (!StringUtil.isNullOrEmpty(channelId, channelLogin)) {
                    result.add(new ChannelStatus(channelId, channelLogin, channelName, title, new StreamCategory(gameId, gameName), tags, labels));
                    continue;
                }
                LOGGER.warning("Error parsing ChannelStatus: Invalid data");
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing ChannelStatus: " + ex);
            return null;
        }
    }

    public String makePutJson() {
        ArrayList tags2 = new ArrayList();
        this.tags.forEach(t -> tags2.add(t.getName()));
        ArrayList<JSONObject> labels2 = new ArrayList<JSONObject>();
        for (StreamLabels.StreamLabel label : StreamLabels.getAvailableLabels()) {
            if (!label.isEditable()) continue;
            labels2.add(JSONUtil.listMapToJSONObject("id", label.getId(), "is_enabled", this.labels.contains(label) ? "true" : "false"));
        }
        return JSONUtil.listMapToJSON("title", this.title, "game_id", this.category.id, "tags", tags2, "content_classification_labels", labels2);
    }

    public boolean sameStatus(ChannelStatus other) {
        String otherTitle;
        String thisTitle = StringUtil.trim(this.title);
        return Objects.equals(thisTitle, otherTitle = StringUtil.trim(other.title)) && Objects.equals(this.category, other.category) && Objects.equals(this.tags, other.tags);
    }

    public String getStatusDifference(ChannelStatus other) {
        String thisTitle = StringUtil.trim(this.title);
        String otherTitle = StringUtil.trim(other.title);
        String difference = "";
        if (!Objects.equals(thisTitle, otherTitle)) {
            difference = StringUtil.append(difference, ", ", "title");
        }
        if (!Objects.equals(this.category, other.category)) {
            difference = StringUtil.append(difference, ", ", "category");
        }
        if (!Objects.equals(this.tags, other.tags)) {
            difference = StringUtil.append(difference, ", ", "tags");
        }
        if (!Objects.equals(StreamLabels.copyEditableLabelsOnly(this.labels), StreamLabels.copyEditableLabelsOnly(other.labels))) {
            difference = StringUtil.append(difference, ", ", "labels");
        }
        return difference;
    }

    public static class StreamTag
    implements Comparable<StreamTag> {
        public static final StreamTag EMPTY = new StreamTag("");
        private final String name;

        public StreamTag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.name;
        }

        public boolean isValid() {
            return !StringUtil.isNullOrEmpty(this.name) && !this.name.contains(" ");
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StreamTag other = (StreamTag)obj;
            return Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + Objects.hashCode(this.name);
            return hash;
        }

        @Override
        public int compareTo(StreamTag o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

