/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import java.awt.Color;
import java.util.Objects;
import java.util.Set;

public class CheerEmoticon
extends Emoticon {
    public final String prefix;
    public final int min_bits;
    public final Color color;
    private volatile String currentBackground;
    private volatile String currentState;
    private final Set<CheerEmoticonUrl> urls;

    public static CheerEmoticon create(String prefix, int min_bits, Color color, Set<CheerEmoticonUrl> urls, String stream) {
        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.TWITCH, "(?i)" + prefix + "([0-9]+)");
        b.setSubType(Emoticon.SubType.CHEER);
        b.addInfo(Helper.formatViewerCount(min_bits) + " bits");
        b.addStreamRestriction(stream);
        b.setStream(stream);
        return new CheerEmoticon(b, prefix, min_bits, color, urls);
    }

    public CheerEmoticon(Emoticon.Builder b, String prefix, int min_bits, Color color, Set<CheerEmoticonUrl> urls) {
        super(b);
        this.prefix = prefix;
        this.min_bits = min_bits;
        this.color = color;
        this.urls = urls;
    }

    @Override
    public String getEmoteUrl(int factor, CachedImage.ImageType imageType) {
        return this.getUrl(this.currentBackground, this.currentState, String.valueOf(factor));
    }

    public String getUrl(String theme, String type, String scale) {
        for (CheerEmoticonUrl url : this.urls) {
            if (!url.background.equals(theme) || !url.type.equals(type) || !url.scale.equals(scale)) continue;
            return url.url;
        }
        return null;
    }

    public void setSettings(String background, String state) {
        if (background == null || state == null) {
            return;
        }
        if (!background.equals(this.currentBackground) || !state.equals(this.currentState)) {
            this.currentBackground = background;
            this.currentState = state;
            this.setAnimated(state.equals("animated"));
            this.clearImages();
        }
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.prefix);
        hash = 17 * hash + this.min_bits;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheerEmoticon other = (CheerEmoticon)obj;
        if (!Objects.equals(this.prefix, other.prefix)) {
            return false;
        }
        return this.min_bits == other.min_bits;
    }

    @Override
    public String toString() {
        return super.toString() + "/" + this.min_bits;
    }

    public String getSimpleCode() {
        return this.prefix + this.min_bits;
    }

    public static class CheerEmoticonUrl {
        public final String url;
        public final String background;
        public final String type;
        public final String scale;

        public CheerEmoticonUrl(String url, String background, String type, String scale) {
            this.url = url;
            this.background = background;
            this.type = type;
            this.scale = scale;
        }
    }
}

