/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Chatty;
import chatty.util.api.CachedManager;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.TwitchApiResultListener;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CheerEmoticonManager
extends CachedManager {
    private static final Logger LOGGER = Logger.getLogger(CheerEmoticonManager.class.getName());
    public static final int CACHED_EMOTICONS_EXPIRE_AFTER = 86400;
    private static final String FILE = Chatty.getPathCreate(Chatty.PathType.CACHE).resolve("cheer_emoticons").toString();
    private final TwitchApiResultListener listener;

    public CheerEmoticonManager(TwitchApiResultListener listener) {
        super(FILE, 86400L, "cheer emoticons");
        this.listener = listener;
    }

    @Override
    public boolean handleData(String data) {
        Set<CheerEmoticon> result = CheerEmoticonManager.parse(data, null);
        if (result == null || result.isEmpty()) {
            return false;
        }
        this.listener.receivedCheerEmoticons(result);
        return true;
    }

    protected static Set<CheerEmoticon> parse(String json, String stream) {
        HashSet<CheerEmoticon> result = new HashSet<CheerEmoticon>();
        JSONParser parser = new JSONParser();
        try {
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray cheers = (JSONArray)root.get("data");
            for (Object entry : cheers) {
                Set<CheerEmoticon> parsedEntry;
                if (!(entry instanceof JSONObject) || (parsedEntry = CheerEmoticonManager.getEntry((JSONObject)entry, stream)) == null) continue;
                result.addAll(parsedEntry);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing Cheers: " + ex);
            return null;
        }
        return result;
    }

    private static Set<CheerEmoticon> getEntry(JSONObject entry, String stream) {
        try {
            HashSet<CheerEmoticon> result = new HashSet<CheerEmoticon>();
            String prefix = (String)entry.get("prefix");
            if (prefix == null) {
                LOGGER.warning("Error parsing Cheer: No prefix");
                return null;
            }
            String type = (String)entry.get("type");
            if (type == null || !type.equals("channel_custom")) {
                stream = null;
            }
            JSONArray tiers = (JSONArray)entry.get("tiers");
            for (Object o : tiers) {
                CheerEmoticon tierResult = CheerEmoticonManager.getTier(prefix, (JSONObject)o, stream);
                if (tierResult == null) continue;
                result.add(tierResult);
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing Cheer: " + ex);
            return null;
        }
    }

    private static CheerEmoticon getTier(String prefix, JSONObject tier, String stream) {
        int min_bits = ((Number)tier.get("min_bits")).intValue();
        Color color = HtmlColors.decode((String)tier.get("color"));
        HashSet<CheerEmoticon.CheerEmoticonUrl> urls = new HashSet<CheerEmoticon.CheerEmoticonUrl>();
        JSONObject images = (JSONObject)tier.get("images");
        CheerEmoticonManager.addUrls(images, urls, "dark", "animated");
        CheerEmoticonManager.addUrls(images, urls, "dark", "static");
        CheerEmoticonManager.addUrls(images, urls, "light", "animated");
        CheerEmoticonManager.addUrls(images, urls, "light", "static");
        return CheerEmoticon.create(prefix, min_bits, color, urls, stream);
    }

    private static void addUrls(JSONObject data, Set<CheerEmoticon.CheerEmoticonUrl> urls, String background, String state) {
        String[] s;
        JSONObject states = (JSONObject)data.get(background);
        JSONObject scales = (JSONObject)states.get(state);
        for (String scale : s = new String[]{"1", "2"}) {
            String url = (String)scales.get(scale);
            urls.add(new CheerEmoticon.CheerEmoticonUrl(url, background, state, scale));
        }
    }
}

