/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.CheerEmoticonManager;
import chatty.util.api.TwitchApi;
import chatty.util.api.TwitchApiResultListener;
import java.util.HashSet;
import java.util.Set;

public class CheerEmoticonManager2 {
    private final TwitchApi api;
    private final TwitchApiResultListener listener;
    private final Set<String> alreadyRequested = new HashSet<String>();

    public CheerEmoticonManager2(TwitchApi api, TwitchApiResultListener listener) {
        this.api = api;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(String stream, boolean force) {
        if (!Helper.isValidStream(stream = Helper.toStream(stream))) {
            return;
        }
        Set<String> set = this.alreadyRequested;
        synchronized (set) {
            if (!this.alreadyRequested.contains(stream) || force) {
                this.alreadyRequested.add(stream);
                this.request(stream);
            }
        }
    }

    private void request(String stream) {
        this.api.userIDs.getUserIDs(r -> {
            if (!r.hasError()) {
                this.api.requests.requestCheerEmoticons(r.getId(stream), stream);
            }
        }, stream);
    }

    protected void dataReceived(String result, String stream, String channelId) {
        Set<CheerEmoticon> parsed = CheerEmoticonManager.parse(result, stream);
        if (parsed != null && !parsed.isEmpty()) {
            this.listener.receivedCheerEmoticons(parsed);
        }
    }
}

