/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.api.CheerEmoticon;
import java.awt.Color;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class CheersUtil {
    private final Set<CheerEmoticon> cheerEmotes = new TreeSet<CheerEmoticon>(new Comparator<CheerEmoticon>(){

        @Override
        public int compare(CheerEmoticon s1, CheerEmoticon s2) {
            int cmp = Integer.compare(s2.min_bits, s1.min_bits);
            return cmp != 0 ? cmp : s1.code.compareTo(s2.code);
        }
    });
    private String currentBackground;
    private String currentState;

    public void add(Set<CheerEmoticon> data) {
        this.cheerEmotes.addAll(data);
        this.setSettings(this.currentBackground, this.currentState);
    }

    public Set<CheerEmoticon> get() {
        return this.cheerEmotes;
    }

    public void setSettings(String background, String state) {
        for (CheerEmoticon emote : this.cheerEmotes) {
            emote.setSettings(background, state);
        }
        this.currentBackground = background;
        this.currentState = state;
    }

    public void setBackgroundColor(Color color) {
        String background = CheersUtil.getBackground(color);
        if (!background.equals(this.currentBackground)) {
            this.setSettings(background, this.currentState);
        }
    }

    public void setState(String state) {
        if (!state.equals(this.currentBackground)) {
            this.setSettings(this.currentBackground, state);
        }
    }

    private static String getBackground(Color color) {
        if (CheersUtil.getLuma(color) < 100.0) {
            return "dark";
        }
        return "light";
    }

    private static double getLuma(Color color) {
        return (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114;
    }

    public String getString(String stream) {
        TreeSet<CheerEmoticon> blah = new TreeSet<CheerEmoticon>(new Comparator<CheerEmoticon>(){

            @Override
            public int compare(CheerEmoticon s1, CheerEmoticon s2) {
                int cmp = s1.code.compareTo(s2.code);
                return cmp != 0 ? cmp : Integer.compare(s1.min_bits, s2.min_bits);
            }
        });
        blah.addAll(this.cheerEmotes);
        StringBuilder b = new StringBuilder();
        for (CheerEmoticon emote : blah) {
            if (stream != null && !emote.streamRestrictionContains(stream)) continue;
            b.append(emote.prefix).append(emote.min_bits).append(" ");
        }
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(CheersUtil.getLuma(Color.DARK_GRAY));
    }
}

