/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.gui.MainGui;
import chatty.util.api.TwitchApi;
import chatty.util.settings.Settings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EmotesetManager {
    private final TwitchApi api;
    private final MainGui g;
    private final Map<String, Set<String>> ircEmotesets = new HashMap<String, Set<String>>();
    private final Set<String> latestIrcEmotesets = new HashSet<String>();
    private final Set<String> emotesets = new HashSet<String>();

    public EmotesetManager(TwitchApi api, MainGui g, Settings settings) {
        this.api = api;
        this.g = g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIrcEmotesets(String channel, Set<String> newSets) {
        boolean changed = false;
        EmotesetManager emotesetManager = this;
        synchronized (emotesetManager) {
            if (newSets == null) {
                newSets = new HashSet<String>();
            }
            this.latestIrcEmotesets.clear();
            this.latestIrcEmotesets.addAll(newSets);
            Set<String> prevSets = this.ircEmotesets.get(channel);
            if (prevSets == null || prevSets.size() != newSets.size()) {
                changed = true;
            }
            if (prevSets == null) {
                this.ircEmotesets.put(channel, new HashSet());
            }
            this.ircEmotesets.get(channel).clear();
            this.ircEmotesets.get(channel).addAll(newSets);
        }
        if (changed) {
            this.g.updateEmotesDialog(Helper.toStream(channel), newSets);
            this.g.updateEmoteNames(newSets);
        }
        this.api.getEmotesBySets(newSets);
    }

    public synchronized Set<String> getEmotesetsByChannel(String channel) {
        if (!this.ircEmotesets.containsKey(channel)) {
            return new HashSet<String>();
        }
        return new HashSet<String>((Collection)this.ircEmotesets.get(channel));
    }
}

