/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.Helper;
import chatty.User;
import chatty.util.ImageCache;
import chatty.util.ImageUrl;
import chatty.util.StringUtil;
import chatty.util.api.CachedImage;
import chatty.util.api.CachedImageManager;
import chatty.util.api.EmoticonSizeCache;
import chatty.util.api.Emoticons;
import chatty.util.seventv.WebPUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Emoticon {
    private static final Logger LOGGER = Logger.getLogger(Emoticon.class.getName());
    public static final String SET_GLOBAL = "0";
    public static final String SET_NONE = null;
    public static final String SET_UNKNOWN = "";
    private static final int DEFAULT_WIDTH = 28;
    private static final int DEFAULT_HEIGHT = 28;
    private static final float MAX_WIDTH = 100.0f;
    private static final float MAX_HEIGHT = 50.0f;
    public final Type type;
    public final SubType subType;
    public final String code;
    public final String regex;
    public final String emoteset;
    private final Set<String> streamRestrictions;
    public final ImageUrl url;
    public final boolean literal;
    public final String stringId;
    public final String stringIdAlias;
    public final String creator;
    private String stream;
    private ArrayList<String> infos;
    private String emotesetInfo;
    private boolean isAnimated;
    private final boolean isZeroWidth;
    private volatile int width;
    private volatile int height;
    private Matcher matcher;
    private CachedImageManager<Emoticon> images;
    private static final Set<String> LITERAL = new HashSet<String>(Arrays.asList("8-)", ":|", ";)", ">(", ":\\", ":)", ":-)", "R)", ":(", ":-(", "B)", "B-)"));

    public String getEmoteUrl(int factor, CachedImage.ImageType imageType) {
        if (this.type == Type.TWITCH || this.type == Type.CUSTOM2) {
            if (this.stringId != null && (factor == 1 || factor == 2 || factor == 4)) {
                return Emoticon.getTwitchEmoteUrlById(this.stringId, factor, imageType);
            }
        } else {
            if (this.type == Type.BTTV && this.stringId != null) {
                return this.getBttvEmoteUrl(this.stringId, factor);
            }
            if (this.type == Type.SEVENTV) {
                return this.getSevenTVEmoteUrl(this.stringId, factor);
            }
            if (this.type == Type.FFZ) {
                return this.getFFZUrl(factor);
            }
            if (this.url != null) {
                return this.url.getUrl(this.stringId, factor);
            }
        }
        return null;
    }

    public static CachedImage.ImageType makeImageType(boolean animated) {
        return animated ? CachedImage.ImageType.ANIMATED_DARK : CachedImage.ImageType.STATIC;
    }

    public static String getTwitchEmoteUrlById(String id, int factor, CachedImage.ImageType imageType) {
        switch (imageType) {
            case STATIC: {
                return String.format(Locale.ROOT, "https://static-cdn.jtvnw.net/emoticons/v2/%s/static/dark/%d.0", id, factor);
            }
            case ANIMATED_DARK: {
                return String.format(Locale.ROOT, "https://static-cdn.jtvnw.net/emoticons/v2/%s/default/dark/%d.0", id, factor);
            }
            case ANIMATED_LIGHT: {
                return String.format(Locale.ROOT, "https://static-cdn.jtvnw.net/emoticons/v2/%s/default/light/%d.0", id, factor);
            }
        }
        return null;
    }

    public String getBttvEmoteUrl(String id, int factor) {
        if (factor == 1 || factor == 2 || factor == 4) {
            if (factor == 4) {
                factor = 3;
            }
            String result = "https://cdn.betterttv.net/emote/{{id}}/{{image}}";
            result = result.replace("{{id}}", id);
            result = result.replace("{{image}}", factor + "x");
            if (WebPUtil.shouldUseWebP()) {
                result = result + ".webp";
            }
            return result;
        }
        return null;
    }

    public String getFFZUrl(int factor) {
        if (this.url == null) {
            return null;
        }
        String result = this.url.getUrl(this.stringId, factor);
        if (result == null) {
            return null;
        }
        String gif = this.isAnimated() && !WebPUtil.shouldUseWebP() ? ".gif" : SET_UNKNOWN;
        return result + gif;
    }

    public String getSevenTVEmoteUrl(String id, int factor) {
        if (StringUtil.isNullOrEmpty(id) || this.url == null || factor > 4) {
            return null;
        }
        String result = this.url.getUrl(id, factor);
        if (result == null) {
            return null;
        }
        if (!WebPUtil.shouldUseWebP()) {
            result = this.isAnimated() ? result.replace(".webp", ".gif") : result.replace(".webp", ".png");
        }
        return result;
    }

    protected Emoticon(Builder builder) {
        String code = builder.search;
        code = code.replace("\\&lt\\;", "<");
        this.code = code = code.replace("\\&gt\\;", ">");
        this.regex = builder.regex;
        this.type = builder.type;
        this.emoteset = builder.emoteset;
        this.url = builder.imageUrl != null ? builder.imageUrl : (!builder.urls.isEmpty() ? new ImageUrl.Builder(builder.stringId, builder.urls).build() : null);
        int width = builder.width;
        int height = builder.height;
        if (width != -1 && height != -1) {
            if ((float)width > 100.0f) {
                height = (int)((float)height / ((float)width / 100.0f));
                width = 100;
            }
            if ((float)height > 50.0f) {
                width = (int)((float)width / ((float)height / 50.0f));
                height = 50;
            }
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            if (builder.width != width || builder.height != height) {
                LOGGER.warning("Changed '" + code + "'/" + (Object)((Object)this.type) + " emote size: " + builder.width + "x" + builder.height + " -> " + width + "x" + height);
            }
        }
        this.width = width;
        this.height = height;
        this.streamRestrictions = builder.streamRestrictions;
        this.stream = builder.stream;
        this.emotesetInfo = builder.emotesetInfo;
        this.literal = builder.literal;
        this.stringId = builder.stringId;
        this.stringIdAlias = builder.stringIdAlias;
        this.creator = builder.creator;
        this.infos = builder.infos;
        if (this.infos != null) {
            this.infos.trimToSize();
        }
        this.isAnimated = builder.isAnimated;
        this.isZeroWidth = builder.isZeroWidth;
        this.subType = builder.subtype;
    }

    private void createMatcher() {
        if (this.matcher == null) {
            String search = !StringUtil.isNullOrEmpty(this.regex) ? this.regex : this.code;
            int flags = 0;
            if (this.type == Type.EMOJI) {
                search = Pattern.quote(search) + "[\ufe0e\ufe0f]?";
            } else {
                if (search.length() < 4) {
                    search = Emoticons.toRegex(search);
                }
                if (this.literal || LITERAL.contains(search)) {
                    search = Pattern.quote(search);
                }
                search = "(?<=^|\\s)" + search + "(?=$|\\s)";
            }
            try {
                this.matcher = Pattern.compile(search, flags).matcher(SET_UNKNOWN);
            }
            catch (PatternSyntaxException ex) {
                LOGGER.warning(String.format("Error compiling emote pattern: '%s' (id: %s, type: %s) [%s]", new Object[]{search, this.stringId, this.type, ex.getLocalizedMessage()}));
                this.matcher = Pattern.compile("(?!)").matcher(SET_UNKNOWN);
            }
        }
    }

    public synchronized Set<String> getStreamRestrictions() {
        if (this.streamRestrictions == null) {
            return null;
        }
        return new HashSet<String>(this.streamRestrictions);
    }

    public synchronized boolean hasStreamRestrictions() {
        return this.streamRestrictions != null;
    }

    public synchronized boolean streamRestrictionContains(String stream) {
        return this.streamRestrictions != null && this.streamRestrictions.contains(stream);
    }

    public synchronized String getStream() {
        return this.stream;
    }

    public synchronized boolean hasStreamSet() {
        return this.stream != null;
    }

    public synchronized void addInfos(Set<String> infosToAdd) {
        if (this.infos == null) {
            this.infos = new ArrayList();
        }
        this.infos.addAll(infosToAdd);
        this.infos.trimToSize();
    }

    public synchronized Set<String> getInfos() {
        if (this.infos == null) {
            return new TreeSet<String>();
        }
        return new TreeSet<String>(this.infos);
    }

    public synchronized boolean isAnimated() {
        return this.isAnimated;
    }

    protected synchronized void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public synchronized boolean isZeroWidth() {
        return this.isZeroWidth;
    }

    public boolean hasGlobalEmoteset() {
        return Emoticon.isGlobalEmoteset(this.emoteset);
    }

    public static boolean isGlobalEmoteset(String emoteset) {
        return emoteset == null || emoteset.equals(SET_GLOBAL);
    }

    public synchronized void setStream(String stream) {
        this.stream = stream;
    }

    public synchronized void setEmotesetInfo(String info) {
        this.emotesetInfo = info;
    }

    public synchronized String getEmotesetInfo() {
        return this.emotesetInfo;
    }

    public synchronized boolean hasEmotesetInfo() {
        return this.emotesetInfo != null;
    }

    public Matcher getMatcher(String text) {
        this.createMatcher();
        return this.matcher.reset(text);
    }

    public CachedImage<Emoticon> getIcon(float scaleFactor, int maxHeight, final CachedImage.ImageType imageType, CachedImage.CachedImageUser user) {
        if (this.images == null) {
            this.images = new CachedImageManager<Emoticon>(this, new CachedImage.CachedImageRequester(){

                @Override
                public String getImageUrl(int scale, CachedImage.ImageType type) {
                    return Emoticon.this.getEmoteUrl(scale, type);
                }

                @Override
                public Dimension getBaseSize() {
                    return Emoticon.this.getDefaultSize();
                }

                @Override
                public boolean forceBaseSize() {
                    return Emoticon.this.width != -1 && Emoticon.this.height != -1;
                }

                @Override
                public void imageLoaded(ImageCache.ImageResult result) {
                    if (Emoticon.this.width == -1 || Emoticon.this.height == -1) {
                        Emoticon.this.width = result.actualBaseSize.width;
                        Emoticon.this.height = result.actualBaseSize.height;
                        if (Emoticon.this.width != 28 || Emoticon.this.height != 28) {
                            Emoticon.this.setCachedSize(Emoticon.this.width, Emoticon.this.height);
                        } else {
                            Emoticon.this.removeCachedSize();
                        }
                    }
                }

                @Override
                public boolean loadImage() {
                    return imageType != CachedImage.ImageType.TEMP;
                }
            }, ("emote_" + (Object)((Object)this.type)).intern());
        }
        return this.images.getIcon(scaleFactor, maxHeight, null, imageType, null, user);
    }

    public void clearImages() {
        if (this.images != null) {
            this.images.clearImages();
        }
    }

    public int clearOldImages(int imageExpireMinutes) {
        if (this.images != null) {
            return this.images.clearOldImages(imageExpireMinutes);
        }
        return 0;
    }

    public CachedImage<Emoticon> getIcon(CachedImage.CachedImageUser user) {
        return this.getIcon(1.0f, 0, CachedImage.ImageType.STATIC, user);
    }

    private String getCachedSizeId() {
        if (this.type == Type.TWITCH) {
            return (Object)((Object)this.type) + "." + this.stringId;
        }
        if (this.type == Type.BTTV) {
            return (Object)((Object)this.type) + "." + this.stringId;
        }
        return null;
    }

    private Dimension getCachedSize() {
        return EmoticonSizeCache.getSize(this.getCachedSizeId());
    }

    private void setCachedSize(int w, int h) {
        if (this.type == Type.TWITCH && this.stringId != null || this.type == Type.BTTV && this.stringId != null) {
            EmoticonSizeCache.setSize(this.getCachedSizeId(), w, h);
        }
    }

    private void removeCachedSize() {
        EmoticonSizeCache.removeSize(this.getCachedSizeId());
    }

    private Dimension getDefaultSize() {
        if (this.width == -1 || this.height == -1) {
            Dimension d = this.getCachedSize();
            if (d != null) {
                return d;
            }
            return new Dimension(28, 28);
        }
        return new Dimension(this.width, this.height);
    }

    public String toString() {
        return this.code;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean matchesUser(User user, Set<String> accessToSets) {
        if (user == null) {
            return true;
        }
        if (!(this.hasGlobalEmoteset() || accessToSets != null && accessToSets.contains(this.emoteset))) {
            return false;
        }
        return !this.hasStreamRestrictions() || this.streamRestrictionContains(user.getStream());
    }

    public boolean allowedForStream(String stream) {
        return !this.hasStreamRestrictions() || this.streamRestrictionContains(stream);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Emoticon other = (Emoticon)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.subType != other.subType) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        if (!Objects.equals(this.emoteset, other.emoteset)) {
            return false;
        }
        return Objects.equals(this.streamRestrictions, other.streamRestrictions);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode((Object)this.type);
        hash = 17 * hash + Objects.hashCode((Object)this.subType);
        hash = 17 * hash + Objects.hashCode(this.code);
        hash = 17 * hash + Objects.hashCode(this.emoteset);
        hash = 17 * hash + Objects.hashCode(this.streamRestrictions);
        return hash;
    }

    public static enum Type {
        TWITCH("twitch", "Twitch", TypeCategory.OFFICIAL),
        CUSTOM2("chattylocal", "Custom2", TypeCategory.OFFICIAL),
        FFZ("ffz", "FFZ", TypeCategory.THIRD_PARTY),
        BTTV("bttv", "BTTV", TypeCategory.THIRD_PARTY),
        SEVENTV("7tv", "7TV", TypeCategory.THIRD_PARTY),
        CUSTOM("custom", "Custom", TypeCategory.OTHER),
        EMOJI("emoji", "Emoji", TypeCategory.OTHER),
        NOT_FOUND_FAVORITE("fav", "NotFoundFavorite", TypeCategory.OTHER);

        public String id;
        public String label;
        public TypeCategory category;

        private Type(String id, String label, TypeCategory category) {
            this.id = id;
            this.label = label;
            this.category = category;
        }

        public static Type fromId(String id) {
            for (Type type : Type.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return null;
        }
    }

    public static class Builder {
        private final Type type;
        private final String search;
        private final Map<Integer, String> urls = new HashMap<Integer, String>();
        private ImageUrl imageUrl;
        private String regex;
        private SubType subtype;
        private int width = -1;
        private int height = -1;
        private boolean literal = false;
        private String stream;
        private String emotesetInfo;
        private Set<String> streamRestrictions;
        private ArrayList<String> infos;
        private String emoteset = SET_NONE;
        private String stringId = null;
        private String stringIdAlias = null;
        private String creator;
        private boolean isAnimated = false;
        private boolean isZeroWidth = false;

        public Builder(Type type, String search) {
            this.type = type;
            this.search = search;
        }

        public Builder setRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder addStreamRestriction(String stream) {
            if (stream != null) {
                if (this.streamRestrictions == null) {
                    this.streamRestrictions = new HashSet<String>();
                }
                this.streamRestrictions.add(StringUtil.toLowerCase(stream));
            }
            return this;
        }

        public Builder setEmoteset(String emoteset) {
            this.emoteset = emoteset;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        public Builder setEmotesetInfo(String info) {
            this.emotesetInfo = info;
            return this;
        }

        public Builder setLiteral(boolean literal) {
            this.literal = literal;
            return this;
        }

        public Builder setStringId(String id) {
            this.stringId = id;
            return this;
        }

        public Builder setStringIdAlias(String id) {
            this.stringIdAlias = id;
            return this;
        }

        public Builder addUrl(int scale, String url) {
            this.urls.put(scale, Helper.checkHttpUrl(url));
            return this;
        }

        public Builder setImageUrl(ImageUrl url) {
            this.imageUrl = url;
            return this;
        }

        public Builder setCreator(String creator) {
            this.creator = creator;
            return this;
        }

        public Builder addInfo(String info) {
            if (info != null) {
                if (this.infos == null) {
                    this.infos = new ArrayList(1);
                }
                this.infos.add(info);
            }
            return this;
        }

        public Builder setAnimated(boolean isAnimated) {
            this.isAnimated = isAnimated;
            return this;
        }

        public Builder setZeroWidth(boolean isZeroWidth) {
            this.isZeroWidth = isZeroWidth;
            return this;
        }

        public Builder setSubType(SubType subtype) {
            this.subtype = subtype;
            return this;
        }

        public Emoticon build() {
            return new Emoticon(this);
        }
    }

    public static enum SubType {
        REGULAR,
        FEATURE_FRIDAY,
        EVENT,
        CHEER,
        FOLLOWER;

    }

    public static enum TypeCategory {
        OFFICIAL,
        THIRD_PARTY,
        OTHER;

    }
}

