/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.SpecialMap;
import chatty.util.StringUtil;
import chatty.util.api.Emoticon;
import chatty.util.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class EmoticonFavorites {
    private static final Logger LOGGER = Logger.getLogger(EmoticonFavorites.class.getName());
    private final Map<String, Favorite> notFoundByName = new HashMap<String, Favorite>();
    private final SpecialMap<Emoticon.Type, Map<String, Favorite>> notFoundByTypeId = new SpecialMap(new HashMap(), () -> new HashMap());
    private final Map<Favorite, Emoticon> favorites = new HashMap<Favorite, Emoticon>();
    private boolean loadedFavoritesFromSettings;

    private Favorite createFavorite(Emoticon emote) {
        if (emote.type == Emoticon.Type.EMOJI) {
            return new Favorite(emote.code, null, null, null);
        }
        return new Favorite(emote.code, emote.emoteset, emote.type, emote.stringId);
    }

    public void loadFavoritesFromSettings(Settings settings) {
        List entriesToLoad = settings.getList("favoriteEmotes");
        this.favorites.clear();
        this.notFoundByName.clear();
        this.notFoundByTypeId.clear();
        for (List item : entriesToLoad) {
            Favorite f = this.listToFavorite(item);
            if (f == null) continue;
            if (f.type != null && f.id != null) {
                this.notFoundByTypeId.getPut(f.type).put(f.id, f);
                continue;
            }
            if (f.code == null) continue;
            this.notFoundByName.put(f.code, f);
        }
        this.loadedFavoritesFromSettings = true;
    }

    public void saveFavoritesToSettings(Settings settings) {
        if (!this.loadedFavoritesFromSettings) {
            LOGGER.warning("Not saving favorite emotes, because they don't seem to have been loaded in the first place.");
            return;
        }
        ArrayList<List<Object>> entriesToSave = new ArrayList<List<Object>>();
        for (Favorite f : this.favorites.keySet()) {
            entriesToSave.add(this.favoriteToList(f));
        }
        for (Favorite f : this.getNotFound()) {
            entriesToSave.add(this.favoriteToList(f));
        }
        settings.putList("favoriteEmotes", entriesToSave);
    }

    public Set<String> getNonGlobalEmotesets() {
        HashSet<String> result = new HashSet<String>();
        for (Favorite f : this.favorites.keySet()) {
            if (Emoticon.isGlobalEmoteset(f.emoteset) || f.emoteset.isEmpty()) continue;
            result.add(f.emoteset);
        }
        return result;
    }

    private Favorite listToFavorite(List<Object> item) {
        try {
            String code = (String)item.get(0);
            String emoteset = item.get(1) instanceof String || item.get(1) == null ? (String)item.get(1) : String.valueOf((Number)item.get(1));
            if (emoteset != null) {
                if (emoteset.equals("-2")) {
                    emoteset = "";
                }
                if (emoteset.equals("-1")) {
                    emoteset = null;
                }
            }
            Emoticon.Type type = null;
            if (item.size() > 3) {
                type = Emoticon.Type.fromId((String)item.get(3));
            }
            String id = null;
            if (item.size() > 4) {
                id = (String)item.get(4);
            }
            return new Favorite(code, emoteset, type, id);
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException ex) {
            return null;
        }
    }

    private List<Object> favoriteToList(Favorite f) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(f.code);
        list.add(f.emoteset);
        list.add(0);
        if (f.type != null && f.id != null) {
            list.add(f.type != null ? f.type.id : null);
            list.add(f.id);
        }
        return list;
    }

    @SafeVarargs
    public final void find(Map<String, Emoticon> twitchEmotesById, Set<Emoticon> ... more) {
        if (this.getNotFoundCount() == 0) {
            return;
        }
        int countBefore = this.notFoundByName.size() + this.notFoundByTypeId.subSize();
        this.findFavorites(twitchEmotesById.values());
        for (Set<Emoticon> emotes : more) {
            this.findFavorites(emotes);
        }
        if (this.getNotFoundCount() == 0) {
            LOGGER.info("Emoticons: Found all remaining " + countBefore + " favorites");
        } else {
            LOGGER.info(String.format("Emoticons: %d favorites still not found", this.getNotFoundCount()));
        }
    }

    private boolean findFavorites(Collection<Emoticon> emotes) {
        for (Emoticon emote : emotes) {
            this.checkFavorite(emote);
            if (this.getNotFoundCount() != 0) continue;
            return true;
        }
        return false;
    }

    private void checkFavorite(Emoticon emote) {
        Favorite f = this.getNotFoundByEmote(emote);
        if (!(f == null || emote.type == Emoticon.Type.TWITCH && StringUtil.isNullOrEmpty(emote.emoteset))) {
            this.favorites.put(f, emote);
            this.notFoundByName.values().remove(f);
            this.notFoundByTypeId.subRemoveValue(f);
        }
    }

    private Favorite getNotFoundByEmote(Emoticon emote) {
        Favorite byName = this.notFoundByName.get(emote.code);
        if (byName != null && (Objects.equals(byName.emoteset, emote.emoteset) || emote.type == Emoticon.Type.CUSTOM2)) {
            return byName;
        }
        return this.notFoundByTypeId.getOptional(emote.type).get(emote.stringId);
    }

    public void addFavorite(Emoticon emote) {
        if (emote.hasStreamRestrictions()) {
            this.notFoundByTypeId.getPut(emote.type).put(emote.stringId, this.createFavorite(emote));
        } else {
            this.favorites.put(this.createFavorite(emote), emote);
        }
    }

    public void removeFavorite(Emoticon emote) {
        this.favorites.keySet().removeIf(fav -> {
            if (fav.type != null && fav.id != null) {
                return fav.type == emote.type && fav.id.equals(emote.stringId);
            }
            return Objects.equals(fav.code, emote.code) && Objects.equals(fav.emoteset, emote.emoteset);
        });
        this.notFoundByName.remove(emote.code);
        this.notFoundByTypeId.getOptional(emote.type).remove(emote.stringId);
    }

    public void removeFavorites(Collection<Favorite> toRemove) {
        toRemove.forEach(fav -> this.favorites.remove(fav));
        this.notFoundByName.values().removeAll(toRemove);
        this.notFoundByTypeId.values().forEach(m -> m.values().removeAll(toRemove));
    }

    public Set<Emoticon> getFavorites() {
        return new HashSet<Emoticon>(this.favorites.values());
    }

    public boolean isFavorite(Emoticon emote) {
        return this.favorites.containsValue(emote) || this.getNotFoundByEmote(emote) != null;
    }

    private int getNotFoundCount() {
        return this.notFoundByName.size() + this.notFoundByTypeId.subSize();
    }

    public Collection<Favorite> getNotFound() {
        ArrayList<Favorite> result = new ArrayList<Favorite>();
        result.addAll(this.notFoundByName.values());
        this.notFoundByTypeId.values().forEach(m -> result.addAll(m.values()));
        Collections.sort(result, (o1, o2) -> o1.code.compareToIgnoreCase(o2.code));
        return result;
    }

    public static class Favorite {
        public final String code;
        public final String emoteset;
        public final Emoticon.Type type;
        public final String id;

        Favorite(String code, String emoteset, Emoticon.Type type, String id) {
            this.code = code;
            this.emoteset = emoteset;
            this.type = type;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Favorite other = (Favorite)obj;
            if (!Objects.equals(this.code, other.code)) {
                return false;
            }
            if (!Objects.equals(this.emoteset, other.emoteset)) {
                return false;
            }
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.code);
            hash = 97 * hash + Objects.hashCode(this.emoteset);
            hash = 97 * hash + Objects.hashCode((Object)this.type);
            hash = 97 * hash + Objects.hashCode(this.id);
            return hash;
        }

        public String toString() {
            if (this.id != null) {
                return String.format("%s (%s) [set:%s, id:%s]", new Object[]{this.code, this.type, this.emoteset, this.id});
            }
            return String.format("%s [set: %s]", this.code, this.emoteset);
        }
    }
}

