/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.MiscUtil;
import chatty.util.api.Requests;
import chatty.util.api.TwitchApiResultListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class EmoticonManager2 {
    private static final Logger LOGGER = Logger.getLogger(EmoticonManager2.class.getName());
    private static final int MAX_NUMBER_OF_SETS_IN_REQUEST = 20;
    private static final long REQUEST_CHECK_INTERVAL = 5000L;
    private final Requests requests;
    private final Set<String> pendingEmotesets = new HashSet<String>();
    private final Set<String> requestedEmotesets = new HashSet<String>();
    private final Set<String> erroredEmotesets = new HashSet<String>();
    private long lastRequestTime;
    private int errorRetrySeconds = 20;

    public EmoticonManager2(TwitchApiResultListener listener, Requests requests) {
        this.requests = requests;
        Timer timer = new Timer("RequestEmotesets");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                EmoticonManager2.this.checkRequest();
            }
        }, 5000L, 5000L);
    }

    public synchronized void addEmotesets(Set<String> emotesetsToAdd) {
        for (String emoteset : emotesetsToAdd) {
            this.addEmoteset(emoteset);
        }
    }

    public synchronized void addError(Set<String> emotesets) {
        this.erroredEmotesets.addAll(emotesets);
    }

    public synchronized void addRequested(Set<String> emotesets) {
        this.requestedEmotesets.addAll(emotesets);
        this.erroredEmotesets.removeAll(emotesets);
    }

    public synchronized void requestNow() {
        this.checkRequest();
    }

    public synchronized void refresh() {
        this.checkErrored();
        this.performRequest(true);
    }

    public synchronized void refresh(Set<String> emotesets) {
        this.requestedEmotesets.addAll(emotesets);
        for (Set<String> split : MiscUtil.splitSetByLimit(emotesets, 20)) {
            this.requests.requestEmotesetsNew(split);
        }
    }

    private synchronized void checkRequest() {
        this.checkErrored();
        if (!this.pendingEmotesets.isEmpty()) {
            this.performRequest(false);
        }
    }

    private synchronized void performRequest(boolean includeAll) {
        HashSet<String> toRequest = new HashSet<String>(this.pendingEmotesets);
        this.pendingEmotesets.clear();
        toRequest.addAll(this.erroredEmotesets);
        this.erroredEmotesets.clear();
        if (includeAll) {
            toRequest.addAll(this.requestedEmotesets);
        }
        this.requestedEmotesets.addAll(toRequest);
        for (Set<String> split : MiscUtil.splitSetByLimit(toRequest, 20)) {
            this.requests.requestEmotesetsNew(split);
        }
        this.lastRequestTime = System.currentTimeMillis();
    }

    private synchronized void checkErrored() {
        long ago;
        if (!this.erroredEmotesets.isEmpty() && (ago = System.currentTimeMillis() - this.lastRequestTime) > (long)(this.errorRetrySeconds * 1000)) {
            LOGGER.info("Retrying requesting emotes: " + this.erroredEmotesets);
            this.pendingEmotesets.addAll(this.erroredEmotesets);
            this.erroredEmotesets.clear();
            this.errorRetrySeconds *= 4;
            this.errorRetrySeconds = Math.min(this.errorRetrySeconds, 3600);
        }
    }

    private void addEmoteset(String emoteset) {
        if (emoteset != null && !emoteset.isEmpty() && !this.requestedEmotesets.contains(emoteset)) {
            this.pendingEmotesets.add(emoteset);
        }
    }
}

