/*
 * Decompiled with CFR 0.152.
 */
package chatty.util.api;

import chatty.util.TwitchEmotesApi;
import chatty.util.api.Emoticon;
import java.util.HashSet;
import java.util.Set;

public class EmoticonUpdate {
    public final Source source;
    public final Set<Emoticon> emotesToAdd;
    public final Emoticon.Type typeToRemove;
    public final Emoticon.SubType subTypeToRemove;
    public final String roomToRemove;
    public final Set<String> setsToRemove;
    public final Set<String> setsAdded;
    public final Set<TwitchEmotesApi.EmotesetInfo> setInfos;

    private EmoticonUpdate(Builder builder) {
        this.emotesToAdd = builder.emotesToAdd;
        this.typeToRemove = builder.typeToRemove;
        this.subTypeToRemove = builder.subTypeToRemove;
        this.roomToRemove = builder.roomToRemove;
        this.setsToRemove = builder.setsToRemove;
        this.setsAdded = builder.setsAdded;
        this.source = builder.source;
        this.setInfos = builder.setInfos;
    }

    public String toString() {
        return String.format("+%d|%s/%s/-%s|%s|%s|%s", new Object[]{this.emotesToAdd.size(), this.setsAdded, this.source, this.typeToRemove, this.subTypeToRemove, this.roomToRemove, this.setsToRemove});
    }

    public static class Builder {
        private final Set<Emoticon> emotesToAdd;
        private Source source = Source.OTHER;
        private Emoticon.Type typeToRemove;
        private Emoticon.SubType subTypeToRemove;
        private Set<String> setsToRemove;
        private Set<String> setsAdded;
        private String roomToRemove;
        private Set<TwitchEmotesApi.EmotesetInfo> setInfos;

        public Builder(Set<Emoticon> emotesToAdd) {
            if (emotesToAdd == null) {
                emotesToAdd = new HashSet<Emoticon>();
            }
            this.emotesToAdd = emotesToAdd;
        }

        public Builder setSource(Source source) {
            this.source = source;
            return this;
        }

        public Builder setTypeToRemove(Emoticon.Type typeToRemove) {
            this.typeToRemove = typeToRemove;
            return this;
        }

        public Builder setSubTypeToRemove(Emoticon.SubType subTypeToRemove) {
            this.subTypeToRemove = subTypeToRemove;
            return this;
        }

        public Builder setSetsToRemove(Set<String> setsToRemove) {
            this.setsToRemove = setsToRemove;
            return this;
        }

        public Builder setSetsAdded(Set<String> setsAdded) {
            this.setsAdded = setsAdded;
            return this;
        }

        public Builder setsSetsAddedToRemove(Set<String> sets) {
            this.setsAdded = sets;
            this.setsToRemove = sets;
            return this;
        }

        public Builder setRoomToRemove(String roomToRemove) {
            this.roomToRemove = roomToRemove;
            return this;
        }

        public Builder setSetInfos(Set<TwitchEmotesApi.EmotesetInfo> setInfos) {
            this.setInfos = setInfos;
            return this;
        }

        public EmoticonUpdate build() {
            return new EmoticonUpdate(this);
        }
    }

    public static enum Source {
        OTHER,
        HELIX_CHANNEL,
        HELIX_SETS;

    }
}

